import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

async function main() {
  // Clear existing data
  await prisma.service.deleteMany();
  await prisma.user.deleteMany();
  await prisma.tenant.deleteMany();

  // Define default tenant data
  const tenantData = {
    id: "cm7lxc3p00000pb7kmdrxsfod",
    name: "MVP Masters",
    email: "info@mvpmasters.com",
    address: {
      street: "Makedonska Treta Brigada 56",
      city: "Skopje",
      state: "Macedonia",
      zip: "1000",
      country: "Macedonia"
    },
    phoneNumber: "+389 72 233 943",
    representative: "Naum Shapkarovski",
    lastInvoiceNumber: "1",
    logoUrl: "https://example.com/default-logo.png",
    vatNumber: "VAT123456789",
    companyNumber: "COMP123456",
    bankAccounts: {
      eur: {
        accountNumber: "1234567890",
        routingNumber: "987654321",
        bicSwift: "DEFBANKXXX",
        iban: "DE89370400440532013000"
      },
      usd: {
        accountNumber: "0987654321",
        routingNumber: "123456789",
        bicSwift: "DEFBANKXXX",
        iban: "US89370400440532013000"
      }
    },
    // Add services along with the tenant creation
    services: {
      create: [
        {
          name: "Web Development",
          sprint: 5000,
          hour: 150,
          month: 8000
        },
        {
          name: "UI/UX Design",
          sprint: 3000,
          hour: 120,
          month: 6000
        },
        {
          name: "Consulting",
          sprint: 4000,
          hour: 200,
          month: 7000
        }
      ]
    }
  };

  // Create default tenant with services
  const defaultTenant = await prisma.tenant.create({
    data: tenantData,
    include: {
      services: true
    }
  });

  // Add default admin user
  const defaultUser = await prisma.user.create({
    data: {
      id: 'dK2y3WezYWWltHCaBRvUFlddkOr2',
      uid: 'dK2y3WezYWWltHCaBRvUFlddkOr2',
      email: 'naum@mvpmasters.com',
      displayName: 'Naum',
      role: 'ADMIN',
      tenantId: 'cm7lxc3p00000pb7kmdrxsfod'
    }
  });

  console.log('🌱 Seeding database...');
  console.log('Seeded default tenant:', defaultTenant);
  console.log('Seeded default user:', defaultUser);
}

main()
  .catch((e) => {
    console.error('Error seeding database:', e);
    process.exit(1);
  })
  .finally(async () => {
    await prisma.$disconnect();
  });
