-- =====================================================
-- 1. INVOICE SUMMARY VIEW
-- =====================================================
-- Shows basic invoice info with client name for easier querying

CREATE OR REPLACE VIEW invoice_summary AS
SELECT 
    i.id,
    i.invoice_number,
    i.invoice_status,
    i.invoice_total_amount,
    i.invoice_currency,
    i.invoice_issue_date,
    i.invoice_due_date,
    c.name as client_name,
    c.email as client_email,
    t.company_name as company_name
FROM "Invoice" i
JOIN "Client" c ON i.client_id = c.id
JOIN "Tenant" t ON i.tenant_id = t.id;

-- =====================================================
-- 2. CLIENT TOTALS VIEW
-- =====================================================
-- Shows total amounts for each client (paid, pending, overdue)

CREATE OR REPLACE VIEW client_totals AS
SELECT 
    c.id as client_id,
    c.name as client_name,
    c.email as client_email,
    COUNT(i.id) as total_invoices,
    SUM(CASE WHEN i.invoice_status = 'PAID' THEN i.invoice_total_amount ELSE 0 END) as total_paid,
    SUM(CASE WHEN i.invoice_status = 'PENDING' THEN i.invoice_total_amount ELSE 0 END) as total_pending,
    SUM(CASE WHEN i.invoice_status = 'OVERDUE' THEN i.invoice_total_amount ELSE 0 END) as total_overdue,
    SUM(i.invoice_total_amount) as total_invoiced
FROM "Client" c
LEFT JOIN "Invoice" i ON c.id = i.client_id
GROUP BY c.id, c.name, c.email;
