import { NextRequest, NextResponse } from 'next/server';
import prisma from 'src/lib/prisma';
import { authenticateRequest } from 'src/lib/auth-middleware';

// Simple API endpoint using SQL VIEWs
export async function GET(request: NextRequest) {
  try {
    // Authenticate the request
    const authResult = await authenticateRequest(request);
    if (authResult instanceof NextResponse) {
      return authResult;
    }
    const { userId, tenantId } = authResult;

    // Use the simple client_totals view
    const clientSummary = await prisma.$queryRaw`
      SELECT 
        client_name,
        client_email,
        total_invoices,
        total_paid,
        total_pending,
        total_overdue,
        total_invoiced
      FROM client_totals
      WHERE client_id IN (
        SELECT id FROM "Client" WHERE tenant_id = ${tenantId}
      )
      ORDER BY total_invoiced DESC
    `;

    return NextResponse.json({
      success: true,
      data: clientSummary,
      message: 'Client summary using SQL VIEW',
    });
  } catch (error) {
    console.error('Error fetching client summary:', error);
    return NextResponse.json(
      {
        error: 'Internal Server Error',
      },
      { status: 500 }
    );
  }
}
