-- Complex invoice analytics indexes

DROP INDEX IF EXISTS idx_invoice_complex_analytics;
DROP INDEX IF EXISTS idx_invoice_tenant_status_date_currency;
DROP INDEX IF EXISTS idx_invoice_overdue_analysis;

-- Main analytics index
CREATE INDEX idx_invoice_complex_analytics ON "Invoice" (
    tenant_id,
    invoice_status,
    invoice_currency,
    DATE_TRUNC('month', invoice_issue_date),
    invoice_total_amount,
    invoice_due_date,
    invoice_issue_date
) 
WHERE invoice_status IN ('PENDING', 'PROCESSING', 'OVERDUE', 'PAID');

-- Overdue invoices index
CREATE INDEX idx_invoice_overdue_analysis ON "Invoice" (
    tenant_id,
    invoice_status,
    invoice_due_date,
    invoice_total_amount DESC,
    client_id
)
WHERE invoice_status = 'OVERDUE';

-- Financial reporting index
CREATE INDEX idx_invoice_financial_reporting ON "Invoice" (
    tenant_id,
    invoice_currency,
    DATE_TRUNC('quarter', invoice_issue_date),
    invoice_status,
    invoice_total_amount
)
WHERE invoice_status != 'DRAFT';

-- Search index
CREATE INDEX idx_invoice_number_search ON "Invoice" (
    tenant_id,
    LOWER(invoice_number),
    invoice_status,
    invoice_issue_date DESC
);

-- Client performance index
CREATE INDEX idx_client_invoice_performance ON "Invoice" (
    client_id,
    tenant_id,
    invoice_status,
    invoice_issue_date DESC,
    invoice_total_amount DESC
)
WHERE invoice_status != 'DRAFT';

-- Time analysis index
CREATE INDEX idx_invoice_temporal_analytics ON "Invoice" (
    tenant_id,
    EXTRACT(YEAR FROM invoice_issue_date),
    EXTRACT(MONTH FROM invoice_issue_date),
    EXTRACT(DOW FROM invoice_issue_date),
    invoice_status,
    invoice_currency,
    invoice_total_amount
)
WHERE invoice_issue_date >= '2020-01-01';

ANALYZE "Invoice";
ANALYZE "Client";
ANALYZE "Tenant";
