INSERT INTO roles (role_name) VALUES 
    ('Admin'), 
    ('User');

INSERT INTO users (first_name, last_name, email, password_hash, role_id, last_login_date, register_date) VALUES 
    ('John', 'Doe', 'john.doe@example.com', 'hashedpassword1', 1, '2025-01-01', '2024-12-01'),
    ('Alice', 'Smith', 'alice.smith@example.com', 'hashedpassword2', 2, '2025-01-02', '2024-12-02'),
    ('Bob', 'Johnson', 'bob.johnson@example.com', 'hashedpassword3', 2, '2025-01-03', '2024-12-03');

INSERT INTO plan (plan_name, max_events, max_notifications, max_predictions) VALUES 
    ('Basic', 100, 50, 10),
    ('Premium', 1000, 500, 100);

INSERT INTO subscription (user_id, plan_id, start_date, end_date, status) VALUES 
    (1, 1, '2025-01-01', '2026-01-01', 'Active'),
    (2, 2, '2025-01-05', '2026-01-05', 'Active'),
    (3, 1, '2025-02-01', '2026-02-01', 'Active');

INSERT INTO events (sql_date, month_year, year, fraction_date, is_root_event, event_code, goldstein_scale, num_mentions, num_sources, num_articles, avg_tone) VALUES 
    ('2025-02-01', '202502', 2025, 2025.0849, TRUE, '023', 5.5, 120, 50, 30, -2.5),
    ('2025-03-10', '202503', 2025, 2025.1925, FALSE, '045', 3.2, 200, 90, 60, 1.5),
    ('2025-04-15', '202504', 2025, 2025.2890, TRUE, '067', 6.8, 300, 120, 80, -3.0);

INSERT INTO actors (actor_code, actor_name, country_code, type_code) VALUES 
    ('USA', 'United States', 'US', 'GOV'),
    ('CHN', 'China', 'CN', 'GOV'),
    ('RUS', 'Russia', 'RU', 'MIL');

INSERT INTO locations (full_name, country_code, adm1_code, latitude, longitude, feature_id) VALUES 
    ('Washington, D.C.', 'US', 'DC', 38.8951, -77.0364, '12345'),
    ('Beijing', 'CN', 'BJ', 39.9042, 116.4074, '54321'),
    ('Moscow', 'RU', 'MSK', 55.7558, 37.6173, '67890');

INSERT INTO event_details (global_event_id, actor_id, location_id) VALUES 
    (1, 1, 1),
    (2, 2, 2),
    (3, 3, 3);

INSERT INTO predictions (event_id, actor_id, predicted_date, prediction_type, confidence_score) VALUES 
    (1, 1, '2025-04-01', 'Conflict', 85.5),
    (2, 2, '2025-05-01', 'Economic Crisis', 78.3),
    (3, 3, '2025-06-01', 'Military Escalation', 90.2);

INSERT INTO conflict_risk (actor1_id, actor2_id, risk_score, predicted_date, description) VALUES 
    (1, 2, 70.2, '2025-06-01', 'High risk of economic sanctions.'),
    (2, 3, 65.8, '2025-07-10', 'Possible territorial dispute.'),
    (1, 3, 55.3, '2025-08-15', 'Diplomatic tensions rising.');

INSERT INTO notifications (user_id, event_id, notification_date, status) VALUES 
    (1, 1, '2025-02-02', 'Sent'),
    (2, 2, '2025-03-11', 'Pending'),
    (3, 3, '2025-04-16', 'Sent');

INSERT INTO event_analytics (actor_id, event_id, date, conflict_coefficient, mentions_count, avg_tone, description) VALUES 
    (1, 1, '2025-02-02', 0.75, 100, -1.2, 'Increased tensions in the region.'),
    (2, 2, '2025-03-11', 0.60, 150, 0.5, 'Positive diplomatic progress.'),
    (3, 3, '2025-04-16', 0.85, 200, -2.0, 'Escalating rhetoric and military movements.');
