package com.example.autopartz.controller;

import com.example.autopartz.model.*;
import com.example.autopartz.repository.*;
import com.example.autopartz.service.PartService;
import com.example.autopartz.service.RepairShopService;
import com.example.autopartz.service.UserService;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;

@Controller
@RequestMapping("/")
public class AdminController {
    private final UserService userService;
    private final CarManufacturerRepository carManufacturerRepository;
    private final WarehousemanRepository warehousemanRepository;
    private final DeliverymanRepository deliverymanRepository;
    private final CategoryRepository categoryRepository;
    private final WarehouseRepository warehouseRepository;
    private final CarRepository carRepository;
    private final PartManufacturerRepository partManufacturerRepository;
    private final PartService partService;
    private final RepairShopService repairShopService;

    public AdminController(UserService userService, CarManufacturerRepository carManufacturerRepository, WarehousemanRepository warehousemanRepository, DeliverymanRepository deliverymanRepository, CategoryRepository categoryRepository, WarehouseRepository warehouseRepository, CarRepository carRepository, PartManufacturerRepository partManufacturerRepository, PartService partService, RepairShopService repairShopService) {
        this.userService = userService;
        this.carManufacturerRepository = carManufacturerRepository;
        this.warehousemanRepository = warehousemanRepository;
        this.deliverymanRepository = deliverymanRepository;
        this.categoryRepository = categoryRepository;
        this.warehouseRepository = warehouseRepository;
        this.carRepository = carRepository;
        this.partManufacturerRepository = partManufacturerRepository;
        this.partService = partService;
        this.repairShopService = repairShopService;
    }

    @GetMapping("/viewUsers")
    public String getAllUsers(Model model){
        List<User> pendingList = userService.findAllUsers().stream().filter(u->u.getAuthorities().contains(Role.ROLE_PENDING_DELIVERYMAN) || u.getAuthorities().contains(Role.ROLE_PENDING_WAREHOUSEMAN)).toList();
        if(pendingList.size()==0){
            model.addAttribute("hasError",true);
        }
        else {
            model.addAttribute("hasError",false);
            model.addAttribute("users", pendingList);
        }
        model.addAttribute("bodyContent", "viewUsers");
        return "master-template";
    }
    @PostMapping("/approve/{id}")
    public void approve(@PathVariable Integer id, HttpServletResponse response){
        if(Objects.equals(userService.findById(id).getAuthorities().stream().findFirst().get(),Role.ROLE_PENDING_WAREHOUSEMAN)){
            Warehouseman wh = (Warehouseman) userService.findById(id);
            wh.setEmployed_from(LocalDate.now());
            warehousemanRepository.save(wh);
            try {
                response.sendRedirect("/viewUsers");
            } catch (IOException e) {
                throw new RuntimeException(e);
            }

        }
        else {
            Deliveryman dm = (Deliveryman) userService.findById(id);
            dm.setEmployed_from(LocalDate.now());
            deliverymanRepository.save(dm);
            try {
                response.sendRedirect("/viewUsers");
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
    @GetMapping("/addPart")
    public String addPart(Model model){
        model.addAttribute("categories",categoryRepository.findAll());
        model.addAttribute("warehouses",warehouseRepository.findAll());
        model.addAttribute("cars",carRepository.findAll());
        model.addAttribute("manufacturers",partManufacturerRepository.findAll());
        model.addAttribute("bodyContent","addPart");
        return "master-template";
    }
    @PostMapping("/addPart")
    public void addPart(@RequestParam String name, @RequestParam(required = false) String description,
                        @RequestParam Integer manufacturer, @RequestParam List<Car> cars,
                        @RequestParam List<Category> categories, @RequestParam Integer warehouse,
                        @RequestParam Integer quantity, @RequestParam Integer amount, HttpServletResponse response){
        partService.addPart(name,description,manufacturer,cars,categories,warehouse,quantity,amount);
        try {
            response.sendRedirect("/");
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
    @GetMapping("/addCarManufacturer")
    public String getCarManView(Model model){
        model.addAttribute("bodyContent","addCarManufacturer");
        return "master-template";
    }
    @PostMapping("/addCarManufacturer")
    public void saveCarManufacturer(@RequestParam String name,@RequestParam String location,
                                    HttpServletResponse response) {
        carManufacturerRepository.save(new CarManufacturer(name,location));
        try {
            response.sendRedirect("/");
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
    @GetMapping("/addPartManufacturer")
    public String getPartManView(Model model){
        model.addAttribute("bodyContent","addPartManufacturer");
        return "master-template";
    }
    @PostMapping("/addPartManufacturer")
    public void savePartManufacturer(@RequestParam String name,@RequestParam String location,
                                     HttpServletResponse response) {
        partManufacturerRepository.save(new PartManufacturer(name,location));
        try {
            response.sendRedirect("/");
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
    @GetMapping("/addCategory")
    public String getCategoryView(Model model){
        model.addAttribute("bodyContent","addCategory");
        return "master-template";
    }
    @PostMapping("/addCategory")
    public void saveCategory(@RequestParam String name,
                             HttpServletResponse response) {
        categoryRepository.save(new Category(name));
        try {
            response.sendRedirect("/");
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
    @GetMapping("/addCar")
    public String getCarView(Model model){
        model.addAttribute("bodyContent","addCar");
        model.addAttribute("manufacturers",carManufacturerRepository.findAll());
        return "master-template";
    }
    @PostMapping("/addCar")
    public void saveCar(@RequestParam Integer since,@RequestParam Integer till,
                             @RequestParam String name,@RequestParam Integer mId,
                                HttpServletResponse response) {
        carRepository.save(new Car(since,till,name,carManufacturerRepository.findById(mId).get()));
        try {
            response.sendRedirect("/");
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
    @GetMapping("/addRepairShop")
    public String getRepairShopView(Model model){
        model.addAttribute("bodyContent","addRepairShop");
        model.addAttribute("manufacturers",carManufacturerRepository.findAll());
        return "master-template";
    }
    @PostMapping("/addRepairShop")
    public void saveRepairShop(@RequestParam String name,@RequestParam String location,
                        @RequestParam String number,@RequestParam Integer carMId,
                        HttpServletResponse response) {
        repairShopService.save(name,location,number,carMId);
        try {
            response.sendRedirect("/");
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
    @GetMapping("/addWarehouse")
    public String getWarehouseView(Model model){
        model.addAttribute("bodyContent","addWarehouse");
        return "master-template";
    }
    @PostMapping("/addWarehouse")
    public void saveWarehouse(@RequestParam String name,
                        HttpServletResponse response) {
        warehouseRepository.save(new Warehouse(name));
        try {
            response.sendRedirect("/");
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
