package com.example.autopartz.service.impl;

import com.example.autopartz.model.Car;
import com.example.autopartz.model.Category;
import com.example.autopartz.model.Part;
import com.example.autopartz.model.Price;
import com.example.autopartz.model.manytomany.PartIsAppropriateForCar;
import com.example.autopartz.model.manytomany.PartIsFromCategory;
import com.example.autopartz.model.manytomany.PartIsInStockInWarehouse;
import com.example.autopartz.model.manytomany.PartIsInStockInWarehouseId;
import com.example.autopartz.repository.*;
import com.example.autopartz.service.PartService;
import com.example.autopartz.service.PriceService;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.time.LocalDate;
import java.util.List;

@Service
public class PartServiceImpl implements PartService {
    private final PartRepository partRepository;
    private final PartIsInStockInWarehouseRepository partIsInStockInWarehouseRepository;
    private final PartIsFromCategoryRepository partIsFromCategoryRepository;
    private final PartIsAppropriateForCarRepository partIsAppropriateForCarRepository;
    private final WarehouseRepository warehouseRepository;
    private final PartManufacturerRepository partManufacturerRepository;
    private final PriceService priceService;

    public PartServiceImpl(PartRepository partRepository, PartIsInStockInWarehouseRepository partIsInStockInWarehouseRepository, PartIsFromCategoryRepository partIsFromCategoryRepository, PartIsAppropriateForCarRepository partIsAppropriateForCarRepository, WarehouseRepository warehouseRepository, PartManufacturerRepository partManufacturerRepository, PriceService priceService) {
        this.partRepository = partRepository;
        this.partIsInStockInWarehouseRepository = partIsInStockInWarehouseRepository;
        this.partIsFromCategoryRepository = partIsFromCategoryRepository;
        this.partIsAppropriateForCarRepository = partIsAppropriateForCarRepository;
        this.warehouseRepository = warehouseRepository;
        this.partManufacturerRepository = partManufacturerRepository;
        this.priceService = priceService;
    }

    @Override
    public List<Part> findAll() {
        return partRepository.findAll();
    }

    @Override
    public Part findById(Integer id) {
        return partRepository.findById(id).orElseThrow(RuntimeException::new);
    }

    @Override
    @Transactional
    public void addPartToWarehouse(Integer partId, Integer quantity, Integer warehouseId) {
        PartIsInStockInWarehouseId tmp = new PartIsInStockInWarehouseId(partId, warehouseId);
        PartIsInStockInWarehouse temp = partIsInStockInWarehouseRepository.findById(tmp).get();
        temp.setQuantity(temp.getQuantity() + quantity);
        partIsInStockInWarehouseRepository.save(temp);
    }

    @Override
    @Transactional
    public void addPart(String name, String description, Integer manufacturer, List<Car> cars, List<Category> categories, Integer warehouse, Integer quantity, Integer amount) {
        Part newPart = new Part(name, description==null ? "" : description, partManufacturerRepository.findById(manufacturer).get(),
                categories, List.of(warehouseRepository.findById(warehouse).get()),cars);
        partRepository.save(newPart);
        priceService.save(new Price(amount, LocalDate.now(),newPart));
        partIsInStockInWarehouseRepository.save(new PartIsInStockInWarehouse(newPart.getId(),warehouse,quantity));
        for (Category c:categories
        ) {
            partIsFromCategoryRepository.save(new PartIsFromCategory(newPart.getId(),c.getId()));
        }
        for (Car car:cars){
            partIsAppropriateForCarRepository.save(new PartIsAppropriateForCar(newPart.getId(),car.getId()));
        }
    }
}
