package com.example.autopartz.service.impl;

import com.example.autopartz.model.RepairShop;
import com.example.autopartz.model.manytomany.RsForCm;
import com.example.autopartz.repository.CarManufacturerRepository;
import com.example.autopartz.repository.RepairShopRepository;
import com.example.autopartz.repository.RsForCmRepository;
import com.example.autopartz.service.RepairShopService;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.util.List;

@Service
public class RepairShopServiceImpl implements RepairShopService {
    private final RepairShopRepository repairShopRepository;
    private final CarManufacturerRepository carManufacturerRepository;
    private final RsForCmRepository rsForCmRepository;

    public RepairShopServiceImpl(RepairShopRepository repairShopRepository, CarManufacturerRepository carManufacturerRepository, RsForCmRepository rsForCmRepository) {
        this.repairShopRepository = repairShopRepository;
        this.carManufacturerRepository = carManufacturerRepository;
        this.rsForCmRepository = rsForCmRepository;
    }

    @Override
    public List<RepairShop> findAll() {
        return repairShopRepository.findAll();
    }

    @Override
    public RepairShop getByName(String name) {
        return repairShopRepository.getRepairShopByName(name);
    }

    @Override
    public RepairShop getById(Integer id) {
        return repairShopRepository.findById(id).get();
    }

    @Override
    @Transactional
    public void save(String name, String location, String number, Integer carMId) {
        RepairShop newRs = new RepairShop(name,location,number,
                List.of(carManufacturerRepository.findById(carMId).get()));
        repairShopRepository.save(newRs);
        rsForCmRepository.save(new RsForCm(newRs.getId(), carMId));
    }
}
