package com.example.autopartz.model;

import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.hibernate.Hibernate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import java.util.Objects;

@Getter
@Setter
@ToString
@RequiredArgsConstructor
@Entity
public class Warehouse {
    @Id
    Integer ID_warehouse;
    @Column(name = "warehouse_location")
    String location;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || Hibernate.getClass(this) != Hibernate.getClass(o)) return false;
        Warehouse warehouse = (Warehouse) o;
        return ID_warehouse != null && Objects.equals(ID_warehouse, warehouse.ID_warehouse);
    }

    @Override
    public int hashCode() {
        return getClass().hashCode();
    }
}
