package com.example.autopartz.service.impl;

import com.example.autopartz.model.Client;
import com.example.autopartz.model.Order;
import com.example.autopartz.model.manytomany.OrderContainsPart;
import com.example.autopartz.repository.OrderContainsPartRepository;
import com.example.autopartz.repository.OrderRepository;
import com.example.autopartz.service.OrderService;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.util.List;
@Service
public class OrderServiceImpl implements OrderService {
    private final OrderRepository orderRepository;
    private final OrderContainsPartRepository orderContainsPartRepository;

    public OrderServiceImpl(OrderRepository orderRepository, OrderContainsPartRepository orderContainsPartRepository) {
        this.orderRepository = orderRepository;
        this.orderContainsPartRepository = orderContainsPartRepository;
    }

    @Override
    public List<Order> findAll() {
        return orderRepository.findAll();
    }

    @Override
    @Transactional
    public Order createOrderAndAddPartToOrder(Client user, Integer partId, Integer quantity) {
        Order order = orderRepository.save(new Order(user));
        orderContainsPartRepository.save(new OrderContainsPart(partId, order.getOrderid(), quantity));
        return order;
    }

    @Override
    public Order findById(Integer id) {
        return orderRepository.findById(id).get();
    }

    @Override
    public void save(Order o) {
        orderRepository.save(o);
    }
}
