package com.example.autopartz.service.impl;

import com.example.autopartz.model.*;
import com.example.autopartz.repository.CarRepository;
import com.example.autopartz.repository.CarSampleRepository;
import com.example.autopartz.repository.ServiceBookRepository;
import com.example.autopartz.repository.UserRepository;
import com.example.autopartz.service.UserService;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.util.List;

@Service
public class UserServiceImpl implements UserService {
    private final UserRepository userRepository;
    private final CarRepository carRepository;
    private final CarSampleRepository carSampleRepository;
    private final ServiceBookRepository serviceBookRepository;

    public UserServiceImpl(UserRepository userRepository, CarRepository carRepository, CarSampleRepository carSampleRepository, ServiceBookRepository serviceBookRepository) {
        this.userRepository = userRepository;
        this.carRepository = carRepository;
        this.carSampleRepository = carSampleRepository;
        this.serviceBookRepository = serviceBookRepository;
    }

    @Override
    public List<User> findAllUsers() {
        return userRepository.findAll();
    }

    @Override
    public User findByUsername(String username) {
        return userRepository.findAllByUsername(username).stream().findFirst().orElseThrow(RuntimeException::new);
    }

    @Override
    public User findById(Integer id) {
        return userRepository.findById(id).get();
    }

    @Override
    @Transactional
    public void addCarSampleForUser(Integer vin, Integer year, Integer power, Integer displacement, String fuel, Integer km, Integer cartype, String username) {
        CarSample cs = new CarSample(vin, year, power, displacement, fuel, km, (Client) this.findByUsername(username), carRepository.findById(cartype).get());
        carSampleRepository.save(cs);
        serviceBookRepository.save(new ServiceBook(cs));
    }
}
