-- polnenje.sql

-- 1) Insert some Users
INSERT INTO "User" (username, email, password_hash, first_name, last_name)
VALUES
('ana123', 'ana@example.com', 'hashA1', 'Ana', 'Naumovska'),
('mikiYoga', 'miki@example.com', 'hashA2', 'Miki', 'Trajkov'),
('davidG', 'david@example.com', 'hashA3', 'David', 'Georgiev');

-- 2) Insert some Instructors
INSERT INTO "Instructor" (first_name, last_name, biography)
VALUES
('Elena', 'Petrova', 'Certified in Vinyasa Yoga'),
('Stefan', 'Ristov', 'Hatha & Yin Yoga Teacher');

-- 3) Insert Trainings
INSERT INTO "Training" (training_name, description, duration, intensity_level)
VALUES
('Vinyasa Flow', 'Linking breath to movement', 60, 'Intermediate'),
('Hatha Basics', 'Focus on foundational poses', 45, 'Beginner');

-- 4) Insert Classes
INSERT INTO "Class" (date, start_time, end_time, location, capacity, seats_available, instructor_id)
VALUES
('2025-06-10', '08:00', '09:00', 'Studio A', 20, 20, 1),
('2025-06-10', '09:30', '10:30', 'Studio B', 15, 15, 2);

-- 5) Insert Events
INSERT INTO "Event" (event_name, description, date, time, location)
VALUES
('Summer Yoga Workshop', 'Outdoor event for all levels', '2025-07-05', '09:00', 'City Park'),
('Meditation Retreat', 'Weekend retreat with meditation', '2025-08-01', '08:00', 'Mountain Lodge');

-- 6) Insert Packages
INSERT INTO "Package" (package_name, price, num_classes)
VALUES
('5-Class Pass', 25.00, 5),
('10-Class Pass', 45.00, 10);

-- 7) Insert Merch Items
INSERT INTO "Merch_Items" (item_name, description, price, quantity_in_stock)
VALUES
('Yoga Mat', 'Eco-friendly TPE mat', 30.00, 50),
('Yoga Block', 'Cork block for alignment', 12.00, 30);

------------------------------------------------
-- Populate bridging tables
------------------------------------------------

-- user_class (books)
INSERT INTO "User_Class" (user_id, class_id)
VALUES
(1, 1),  -- Ana books Class 1
(2, 1),  -- Miki also books Class 1
(3, 2);  -- David books Class 2

-- class_training (is_scheduled_for)
INSERT INTO "Class_Training" (class_id, training_id)
VALUES
(1, 1),  -- Class 1 includes Vinyasa Flow
(2, 2);  -- Class 2 includes Hatha Basics

-- user_event (registers)
INSERT INTO "User_Event" (user_id, event_id)
VALUES
(1, 1),  -- Ana registers for Summer Yoga Workshop
(2, 2);  -- Miki registers for Meditation Retreat

-- user_package (buys)
INSERT INTO "User_Package" (user_id, package_id)
VALUES
(1, 1), -- Ana buys 5-Class Pass
(2, 2); -- Miki buys 10-Class Pass

-- user_merch (purchases)
INSERT INTO "User_Merch" (user_id, merch_id)
VALUES
(1, 1),  -- Ana buys a Yoga Mat
(1, 2),  -- Ana also buys a Yoga Block
(2, 2);  -- Miki buys a Yoga Block

-- package_class (is_for)
INSERT INTO "Package_Class" (package_id, class_id)
VALUES
(1, 1),  -- 5-Class Pass includes Class 1
(1, 2),  -- 5-Class Pass includes Class 2
(2, 1);  -- 10-Class Pass also includes Class 1

-- End of polnenje.sql
