/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package jogl_proekt;

import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureIO;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;

import javax.media.opengl.*;
import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.glu.GLU;
import javax.swing.*;

public class Main implements GLEventListener {

	private static GraphicsEnvironment graphic_enviroment;
	private static boolean isFullScreen = false;
	private static DisplayMode dm, dm_old;
	private static Dimension xgraphic;
	private static Point point = new Point(0, 0);
	private GLU glu = new GLU();
	private static Camera c;
	private int skybox_texture[];
	private static Client client;

	public void nacrtaj_kursor(GLAutoDrawable glad) {
		final GL2 gl = glad.getGL().getGL2();

		IntBuffer screen = IntBuffer.allocate(4);
		gl.glGetIntegerv(GL2.GL_VIEWPORT, screen);

		gl.glMatrixMode(GL2.GL_PROJECTION);
		gl.glPushMatrix();
		gl.glLoadIdentity();
		gl.glOrtho(0, screen.get(2), 0, screen.get(3), -1, 1);

		gl.glMatrixMode(GL2.GL_MODELVIEW);
		gl.glPushMatrix();
		gl.glLoadIdentity();

		gl.glPushAttrib(GL2.GL_DEPTH_TEST);
		gl.glDisable(GL2.GL_DEPTH_TEST);
		gl.glDepthMask(false);

		gl.glDisable(GL2.GL_TEXTURE_2D);
		gl.glDisable(GL2.GL_LIGHTING);
		gl.glColor3f(0.5f, 0.5f, 0.8f);

		gl.glTranslatef(screen.get(2) / 2, screen.get(3) / 2, 0);

		gl.glEnable(GL2.GL_LINE_SMOOTH);

		gl.glBegin(GL2.GL_LINES);
		gl.glVertex2f(15, 15);
		gl.glVertex2f(5, 5);

		gl.glVertex2f(-15, 15);
		gl.glVertex2f(-5, 5);

		gl.glVertex2f(-5, -5);
		gl.glVertex2f(-15, -15);

		gl.glVertex2f(5, -5);
		gl.glVertex2f(15, -15);
		gl.glEnd();

		gl.glDisable(GL2.GL_LINE_SMOOTH);
		gl.glEnable(GL2.GL_POINT_SMOOTH);

		gl.glColor3f(0.45f, 0.5f, 0.6f);
		gl.glPointSize(2.0f);
		// gl.glBegin(GL.GL_POINTS);
		//
		//
		// gl.glVertex2i(0, 0);
		// gl.glEnd();
		gl.glDisable(GL2.GL_POINT_SMOOTH);

		gl.glEnable(GL2.GL_TEXTURE);
		gl.glEnable(GL2.GL_LIGHTING);
		gl.glPopMatrix();

		gl.glPopAttrib();
		gl.glMatrixMode(GL2.GL_PROJECTION);
		gl.glPopMatrix();
		gl.glMatrixMode(GL2.GL_MODELVIEW);
		gl.glPopMatrix();

	}

	public void nacrtaj_skybox(GLAutoDrawable glad, int golemina) {
		final GL2 gl = glad.getGL().getGL2();

		gl.glDisable(GL2.GL_LIGHTING);
		gl.glEnable(GL2.GL_TEXTURE_2D);

		gl.glColor3f(0.8f, 0.8f, 0.8f);

		gl.glPushMatrix();
		gl.glTranslatef(-golemina / 2, -golemina / 2, -golemina / 2);

		gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[2]);
		gl.glBegin(GL2.GL_QUADS);
		gl.glTexCoord2f(1, 0);
		gl.glVertex3i(0, 0, 0); // predna
		gl.glTexCoord2f(1, 1);
		gl.glVertex3i(0, golemina, 0);
		gl.glTexCoord2f(0, 1);
		gl.glVertex3i(golemina, golemina, 0);
		gl.glTexCoord2f(0, 0);
		gl.glVertex3i(golemina, 0, 0);
		gl.glEnd();

		gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[0]);
		gl.glBegin(GL2.GL_QUADS);
		gl.glTexCoord2f(0, 0);
		gl.glVertex3i(0, 0, golemina); // zadna
		gl.glTexCoord2f(0, 1);
		gl.glVertex3i(0, golemina, golemina);
		gl.glTexCoord2f(1, 1);
		gl.glVertex3i(golemina, golemina, golemina);
		gl.glTexCoord2f(1, 0);
		gl.glVertex3i(golemina, 0, golemina);
		gl.glEnd();

		gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[3]);
		gl.glBegin(GL2.GL_QUADS);
		gl.glTexCoord2f(0, 0);
		gl.glVertex3i(0, 0, 0); // levo
		gl.glTexCoord2f(1, 0);
		gl.glVertex3i(0, 0, golemina);
		gl.glTexCoord2f(1, 1);
		gl.glVertex3i(0, golemina, golemina);
		gl.glTexCoord2f(0, 1);
		gl.glVertex3i(0, golemina, 0);
		gl.glEnd();

		gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[4]);
		gl.glBegin(GL2.GL_QUADS);
		gl.glTexCoord2f(1, 0);
		gl.glVertex3i(golemina, 0, 0); // desno
		gl.glTexCoord2f(0, 0);
		gl.glVertex3i(golemina, 0, golemina);
		gl.glTexCoord2f(0, 1);
		gl.glVertex3i(golemina, golemina, golemina);
		gl.glTexCoord2f(1, 1);
		gl.glVertex3i(golemina, golemina, 0);
		gl.glEnd();

		gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[1]);
		gl.glBegin(GL2.GL_QUADS);
		gl.glTexCoord2f(1, 0);
		gl.glVertex3i(0, 0, 0);// dole
		gl.glTexCoord2f(1, 1);
		gl.glVertex3i(golemina, 0, 0);
		gl.glTexCoord2f(0, 1);
		gl.glVertex3i(golemina, 0, golemina);
		gl.glTexCoord2f(0, 0);
		gl.glVertex3i(0, 0, golemina);
		gl.glEnd();

		gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[5]);
		gl.glBegin(GL2.GL_QUADS);
		gl.glTexCoord2f(1, 1);
		gl.glVertex3i(0, golemina, 0);// gore
		gl.glTexCoord2f(1, 0);
		gl.glVertex3i(golemina, golemina, 0);
		gl.glTexCoord2f(0, 0);
		gl.glVertex3i(golemina, golemina, golemina);
		gl.glTexCoord2f(0, 1);
		gl.glVertex3i(0, golemina, golemina);
		gl.glEnd();

		gl.glPopMatrix();
		gl.glEnable(GL2.GL_LIGHTING);
		gl.glDisable(GL2.GL_TEXTURE_2D);
	}

	public void nacrtaj_pod(GLAutoDrawable glad) {
		final GL2 gl = glad.getGL().getGL2();

		gl.glColor3f(0.3f, 0.4f, 0.8f);

		gl.glBegin(GL2.GL_QUADS);
		gl.glNormal3f(0, 1, 0);
		for (int i = 1; i < 20; i++) {
			for (int j = 1; j < 6; j++) {
				gl.glTexCoord2f(i / 20.0f, j / 6.0f);
				gl.glVertex3f(i, -1.0f, j);
				gl.glTexCoord2f((i + 1) / 20.0f, j / 6.0f);
				gl.glVertex3f(i + 1, -1.0f, j);
				gl.glTexCoord2f((i + 1) / 20.0f, (j + 1) / 6.0f);
				gl.glVertex3f(i + 1, -1.0f, j + 1);
				gl.glTexCoord2f(i / 20.0f, (j + 1) / 6.0f);
				gl.glVertex3f(i, -1.0f, j + 1);
			}
		}
		gl.glEnd();
	}

	public void nacrtaj_Koord_Sistem(GLAutoDrawable glad) {
		final GL2 gl = glad.getGL().getGL2();

		gl.glColor3f(1.0f, 0.0f, 0.0f);

		gl.glBegin(GL2.GL_LINES);

		gl.glVertex3f(0, 0.0f, 0);// x
		gl.glVertex3f(3, 0.0f, 0);

		gl.glColor3f(0.0f, 1.0f, 0.0f);
		gl.glVertex3f(0, 0.0f, 0);// y
		gl.glVertex3f(0, 3.0f, 0);

		gl.glColor3f(0.0f, 0.0f, 1.0f);
		gl.glVertex3f(0, 0.0f, 0);// z
		gl.glVertex3f(0, 0.0f, 3);

		gl.glEnd();

	}

	@Override
	public void init(GLAutoDrawable glad) {
		final GL2 gl = glad.getGL().getGL2();

		gl.glShadeModel(GL2.GL_SMOOTH);
		gl.glClearColor(0.1f, 0.1f, 0.1f, 0.0f);
		gl.glClearDepth(1.0f);
		gl.glEnable(GL2.GL_DEPTH_TEST);
		gl.glDepthFunc(GL2.GL_LEQUAL);
		gl.glHint(GL2.GL_PERSPECTIVE_CORRECTION_HINT, GL2.GL_NICEST);

		// svetlo
		float[] lightAmbient = { 0.5f, 0.5f, 0.5f, 1.0f };
		float[] lightDiffuse = { 1.0f, 1.0f, 1.0f, 1.0f };
		float[] lightPosition = { 4.0f, 10.0f, 4.0f, 1.0f };

		gl.glLightfv(GL2.GL_LIGHT1, GL2.GL_AMBIENT, lightAmbient, 0);
		gl.glLightfv(GL2.GL_LIGHT1, GL2.GL_DIFFUSE, lightDiffuse, 0);
		gl.glLightfv(GL2.GL_LIGHT1, GL2.GL_POSITION, lightPosition, 0);

		gl.glEnable(GL2.GL_LIGHT1);
		gl.glEnable(GL2.GL_LIGHTING);

		// tekstura
		gl.glEnable(GL2.GL_TEXTURE_2D);
		try {
			skybox_texture = new int[6];
			File file = new File("resources/skybox/toh_bk.tga");
			Texture t = TextureIO.newTexture(file, true);
			skybox_texture[0] = t.getTextureObject(gl);
			gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MAG_FILTER,
					GL2.GL_LINEAR);
			gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MIN_FILTER,
					GL2.GL_LINEAR);
			gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[0]);

			file = new File("resources/skybox/toh_dn.tga");
			t = TextureIO.newTexture(file, true);
			skybox_texture[1] = t.getTextureObject(gl);
			gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MAG_FILTER,
					GL2.GL_LINEAR);
			gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MIN_FILTER,
					GL2.GL_LINEAR);
			gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[1]);

			file = new File("resources/skybox/toh_ft.tga");
			t = TextureIO.newTexture(file, true);
			skybox_texture[2] = t.getTextureObject(gl);
			gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MAG_FILTER,
					GL2.GL_LINEAR);
			gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MIN_FILTER,
					GL2.GL_LINEAR);
			gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[2]);

			file = new File("resources/skybox/toh_lf.tga");
			t = TextureIO.newTexture(file, true);
			skybox_texture[3] = t.getTextureObject(gl);
			gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MAG_FILTER,
					GL2.GL_LINEAR);
			gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MIN_FILTER,
					GL2.GL_LINEAR);
			gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[3]);

			file = new File("resources/skybox/toh_rt.tga");
			t = TextureIO.newTexture(file, true);
			skybox_texture[4] = t.getTextureObject(gl);
			gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MAG_FILTER,
					GL2.GL_LINEAR);
			gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MIN_FILTER,
					GL2.GL_LINEAR);
			gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[4]);

			file = new File("resources/skybox/toh_up.tga");
			t = TextureIO.newTexture(file, true);
			skybox_texture[5] = t.getTextureObject(gl);
			gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MAG_FILTER,
					GL2.GL_LINEAR);
			gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MIN_FILTER,
					GL2.GL_LINEAR);
			gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[5]);

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Override
	public void dispose(GLAutoDrawable glad) {
		final GL2 gl = glad.getGL().getGL2();
	}

	@Override
	public void display(GLAutoDrawable glad) {
		final GL2 gl = glad.getGL().getGL2();
		gl.glClear(GL2.GL_COLOR_BUFFER_BIT | GL2.GL_DEPTH_BUFFER_BIT);
		gl.glLoadIdentity();

		float movevel = 0.34f;
		if (c.W) {
			if (c.camPitch != 90 && c.camPitch != -90) // if we are facing
														// directly up or down,
														// we don't go forward,
														// it will be commented
														// out, when there will
														// be gravity
			{
				c.moveCamera(movevel, 0.0f); // move forward
			}
			c.moveCameraUp(movevel, 0.0f); // move up/down
		}
		if (c.S) {
			// same, just we use 180 degrees, so we move at the different
			// direction (move back)
			if (c.camPitch != 90 && c.camPitch != -90) {
				c.moveCamera(movevel, 180.0f);
			}
			c.moveCameraUp(movevel, 180.0f);
		}
		if (c.D) {
			c.moveCamera(movevel, 90.0f);
		}
		if (c.A) {
			c.moveCamera(movevel, 270.0f);
		}

		glu.gluLookAt(0, 0, 0, 0, 0, 1, 0, 1, 0);

		// prakjanje na koordinatite na serverot
		client.sendMessage("koordinati X=" + -c.camX + " Y=" + -c.camY + " Z="
				+ -c.camZ);
		

	//	System.out.println("Koordinati na igrac X=" + -c.camX + " Y=" + -c.camY
	//			+ " Z=" + -c.camZ);
		gl.glRotatef(-c.camPitch, 1.0f, 0.0f, 0.0f);
		gl.glRotatef(c.camYaw, 0.0f, 1.0f, 0.0f);
		nacrtaj_skybox(glad, 40);
		gl.glTranslatef(-c.camX, -c.camY, -c.camZ);
		nacrtaj_pod(glad);

		nacrtaj_kursor(glad);
		gl.glFlush();

	}

	@Override
	public void reshape(GLAutoDrawable glad, int x, int y, int width, int height) {

		final GL2 gl = glad.getGL().getGL2();
		if (height <= 0) {
			height = 1;
		}
		final float h = (float) width / (float) height;
		gl.glViewport(0, 0, width, height);
		gl.glMatrixMode(GL2.GL_PROJECTION);
		gl.glLoadIdentity();
		glu.gluPerspective(45.0f, h, 1.0, 100.0);
		gl.glMatrixMode(GL2.GL_MODELVIEW);
		gl.glLoadIdentity();

	}

	public static void main(String[] args) {
		final GLProfile profile = GLProfile.get(GLProfile.GL2);
		GLCapabilities capabilities = new GLCapabilities(profile);

		final GLCanvas canvas = new GLCanvas(capabilities);
		Main jp = new Main();

		// konekcija do serverot
		client = new Client("127.0.0.1"); // localhost
		client.startRunning();

		canvas.addGLEventListener(jp);
		canvas.setSize(800, 800);

		final Animator animator = new Animator(canvas);

		JFrame frame = new JFrame("PROEKT");
		frame.getContentPane().add(canvas);

		// fullscreen na cela igra
		// frame.setUndecorated(true);
		// frame.setExtendedState(Frame.MAXIMIZED_BOTH);

		frame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				if (animator.isStarted()) {
					// prakja poraka kraj i gasi konekcii
					client.sendMessage(" KRAJ");
					client.izgasiSe();
					animator.stop();
				}
				System.exit(0);
			}
		});

		frame.setSize(frame.getContentPane().getPreferredSize());

		graphic_enviroment = GraphicsEnvironment.getLocalGraphicsEnvironment();

		GraphicsDevice[] devices = graphic_enviroment.getScreenDevices();

	/*	for (GraphicsDevice graphicsDevice : devices) {
			System.out.println(graphicsDevice.toString());
		}*/

		dm_old = devices[0].getDisplayMode();
		dm = dm_old;
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

		int windowX = Math.max(0, (screenSize.width - frame.getWidth()) / 2);
		int windowY = Math.max(0, (screenSize.height - frame.getHeight()) / 2);

		frame.setLocation(windowX, windowY);
		frame.setVisible(true);

		JPanel p = new JPanel();
		p.setPreferredSize(new Dimension(0, 0));
		frame.add(p, BorderLayout.SOUTH);

		c = new Camera(canvas);
		canvas.addMouseMotionListener(c);
		canvas.addKeyListener(c);

		animator.start();
	}
}
