package jogl_proekt;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class Server {

    private ObjectOutputStream output;
    private ObjectInputStream input;
    private ServerSocket server;
    private Socket connection;

    // set up and run server
    public void startRunning() {
        try {
            // porta i broj na lugje koi moze da se pustat
            server = new ServerSocket(1234, 50);
            while (true) {
                try {
                    cekajIgraci();
                    setupStreams();
                    dodekaIgra();
                } catch (EOFException eofException) {
                    showMessage("Igracot se izgasi");
                } finally {
                    izgasiSe();
                }

            }
        } catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    // ceka igraci da se konektiraat, i izvestuva deka si konektiran
    private void cekajIgraci() throws IOException {
        showMessage("Ceka nekoj da se konektira...");
        connection = server.accept();
        showMessage("Konektiran na " + connection.getInetAddress().getHostName());
    }

    // stream za prakjanje i primanje data
    private void setupStreams() throws IOException {
        output = new ObjectOutputStream(connection.getOutputStream());
        output.flush();
        input = new ObjectInputStream(connection.getInputStream());
        showMessage("Streas are  now set");
    }

    // dodeka se igra
    private void dodekaIgra() throws IOException {
        String message = "Ti si komektiran!!";
        //sendMessage(message);
        // ovozmozi da igra = true
        do {
            try {
                // porakata sto e pratena od klientot
                message = (String) input.readObject();
                showMessage(message);
                sendMessage(message);
            } catch (ClassNotFoundException classNotFoundException) {
                showMessage("Neznam sto e toa");
            }

        } while (!message.equals("KRAJ"));
        // koga da ja prekine igrata

    }

    // gasi streams i sockets otkako ke zavrsis so igranje
    private void izgasiSe() {
        showMessage("Zatvoranje konekcii...");
        // ovozmozeno da igra = false
        try {
            output.close();
            input.close();
            connection.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        showMessage("Zatvoreno");
    }

    // prakja poraka do klientot
    private void sendMessage(String message) {
        try {
            // prakja poraka
            output.writeObject("SERVER - " + message);
            output.flush();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showMessage(final String text) {
        System.out.println(text);
    }
}
