package jogl_proekt;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.Socket;

public class Client {

	private ObjectOutputStream output;
	private ObjectInputStream input;
	private String message = "";
	private String serverIP = "";
	private Socket connection;

	// constructor
	public Client(String host) {
		serverIP = host;
	}

	public void startRunning() {
		try {
			connectToServer();
			setupStreams();
		} catch (EOFException e) {
			showMessage("Igracot ja prekina konekcijata");
		} catch (IOException e) {
			showMessage("Nemoze da se konektira so serverot");
		}
	}

	// connec to server
	private void connectToServer() throws IOException {
		showMessage("Attempting connection...");
		connection = new Socket(InetAddress.getByName(serverIP), 1234);
		showMessage("Connected to " + connection.getInetAddress().getHostName());
	}

	// stream za prakjanje i primanje data
	private void setupStreams() throws IOException {
		output = new ObjectOutputStream(connection.getOutputStream());
		output.flush();
		input = new ObjectInputStream(connection.getInputStream());
		showMessage("Streas are  now setup!");
	}

	// ne go koristam nigde momentalno
	// dodeka igra
	private void dodekaIgra() throws IOException {
		// ovozmozi da igra = true ???

		do {

			try {
				// porakata sto e pratena od serverot
				message = (String) input.readObject();
				showMessage(message);
			} catch (ClassNotFoundException classNotFoundException) {
				showMessage("Neznam sto e toa");
			}

		} while (!message.equals("Nesto"));
		// koga da ja prekine igrata*/

	}

	// izgasi streams i sockets
	public void izgasiSe() {
		showMessage("Zatvoranje konekcii...");
		try {
			output.close();
			input.close();
			connection.close();
		} catch (Exception e) {
			showMessage("Ne se otvoreni za da gi zatvori");
		}
		showMessage("Zatvoreno!!!");
	}

	// poraka do serverot
	public void sendMessage(String message) {
		try {
			// prakja poraka
			output.writeObject(Inet4Address.getLocalHost().getHostAddress()+ "," + message);
			output.flush();
			
			message = (String) input.readObject();
			showMessage(message);
		} catch (Exception e) {
			System.out.print("");
			// showMessage("Ne e konektiran za da prati podatoci");
		}
	}

	private void showMessage(final String text) {
		System.out.println(text);
	}
	
	
	

}
