
import java.io.EOFException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class Server {

    private ServerSocket server;
    private Socket connection;


    public static void main(String[] args) {
        new Server().startRunning();
    }

    // set up and run server
    public void startRunning() {
        try {
            // porta i broj na lugje koi moze da se pustat
            server = new ServerSocket(1234, 50);
            while (true) {
                try {
                    cekajIgraci();
                } catch (EOFException eofException) {
                    showMessage("Igracot se izgasi");
                }
            }
        } catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    // ceka igraci da se konektiraat, i izvestuva deka si konektiran
    private void cekajIgraci() throws IOException {
        showMessage("Ceka nekoj da se konektira...");
        connection = server.accept();
        new ServerThread(connection).start();
        showMessage("Konektiran na " + connection.getInetAddress().getHostName());
    }

    private void showMessage(final String text) {
        System.out.println(text);
    }
}
