
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerThread extends Thread {

    private Socket socket;
    private ObjectInputStream input;
    private ObjectOutputStream output;
    private List<Klient> klienti = new ArrayList<Klient>();

    public ServerThread(Socket socket) {
        this.socket = socket;
    }

    public void run() {
        try {
            setupStreams();
            while (true) {
                dodekaIgra();
            }
        } catch (IOException ex) {
            Logger.getLogger(ServerThread.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            izgasiSe();
        }

    }

    // stream za prakjanje i primanje data
    private void setupStreams() throws IOException {
        output = new ObjectOutputStream(socket.getOutputStream());
        output.flush();
        input = new ObjectInputStream(socket.getInputStream());
        System.out.println("Streas are  now set");
    }

    // dodeka se igra
    private void dodekaIgra() throws IOException {
        String message = "";
        //sendMessage(message);
        // ovozmozi da igra = true
        do {
            try {
                // porakata sto e pratena od klientot
                message = (String) input.readObject();
                System.out.println(message);
                sendMessage(message);
            } catch (ClassNotFoundException classNotFoundException) {
                System.out.println("Neznam sto e toa");
            }

        } while (!message.equals("KRAJ"));
        // koga da ja prekine igrata

    }
    // prakja poraka do klientot

    private void sendMessage(String message) {
        try {
            // prakja poraka
            output.writeObject("SERVER - " + message);
            output.flush();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    // gasi streams i sockets otkako ke zavrsis so igranje

    private void izgasiSe() {
        System.out.println("Zatvoranje konekcii...");
        // ovozmozeno da igra = false
        try {
            output.close();
            input.close();
            socket.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Zatvoreno");
    }
}
