/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package bbbbb_skok;

/**
 *
 * @author Stekac
 */
import com.bulletphysics.ContactAddedCallback;
import com.bulletphysics.collision.broadphase.BroadphaseInterface;
import com.bulletphysics.collision.broadphase.DbvtBroadphase;
import com.bulletphysics.collision.dispatch.CollisionConfiguration;
import com.bulletphysics.collision.dispatch.CollisionDispatcher;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.dispatch.CollisionWorld;
import com.bulletphysics.collision.dispatch.CollisionWorld.ClosestRayResultCallback;
import com.bulletphysics.collision.dispatch.DefaultCollisionConfiguration;
import com.bulletphysics.collision.narrowphase.ManifoldPoint;
import com.bulletphysics.collision.narrowphase.PersistentManifold;
import com.bulletphysics.collision.shapes.BoxShape;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.collision.shapes.CylinderShape;
import com.bulletphysics.collision.shapes.StaticPlaneShape;
import com.bulletphysics.dynamics.DiscreteDynamicsWorld;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureIO;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.nio.IntBuffer;
import com.bulletphysics.dynamics.DynamicsWorld;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.RigidBodyConstructionInfo;
import com.bulletphysics.dynamics.constraintsolver.SequentialImpulseConstraintSolver;
import com.bulletphysics.linearmath.DefaultMotionState;
import com.bulletphysics.linearmath.IDebugDraw;
import com.bulletphysics.linearmath.MotionState;
import com.bulletphysics.linearmath.Transform;
import java.util.ArrayList;

import javax.media.opengl.*;
import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.glu.GLU;
import javax.swing.*;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;

public class skok implements GLEventListener {

    private static GraphicsEnvironment graphic_enviroment;
    private static boolean isFullScreen = false;
    private static DisplayMode dm, dm_old;
    private static Dimension xgraphic;
    private static Point point = new Point(0, 0);
    private GLU glu = new GLU();
    private static Camera c;
    private int skybox_texture[];

    private int ID = 0;
    private DynamicsWorld dynamicsWorld;
    private RigidBody rigid_body_kocka;
    private RigidBody rigid_body_kocka2;
    private RigidBody rigid_body_pod;
    private RigidBody dzid;
    private RigidBody player;
    private boolean fizika = true;
    private ArrayList<BulletObject> bodies = new ArrayList<BulletObject>();
    private ContactAddedCallback a;

    public void nacrtaj_kursor(GLAutoDrawable glad) {
        final GL2 gl = glad.getGL().getGL2();

        IntBuffer screen = IntBuffer.allocate(4);
        gl.glGetIntegerv(GL2.GL_VIEWPORT, screen);

        gl.glMatrixMode(GL2.GL_PROJECTION);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glOrtho(0, screen.get(2), 0, screen.get(3), -1, 1);

        gl.glMatrixMode(GL2.GL_MODELVIEW);
        gl.glPushMatrix();
        gl.glLoadIdentity();

        gl.glPushAttrib(GL2.GL_DEPTH_TEST);
        gl.glDisable(GL2.GL_DEPTH_TEST);
        gl.glDepthMask(false);

        gl.glDisable(GL2.GL_TEXTURE_2D);
        gl.glDisable(GL2.GL_LIGHTING);
        gl.glColor3f(0.5f, 0.5f, 0.8f);

        gl.glTranslatef(screen.get(2) / 2, screen.get(3) / 2, 0);

        gl.glEnable(GL2.GL_LINE_SMOOTH);

        gl.glBegin(GL2.GL_LINES);
        gl.glVertex2f(15, 15);
        gl.glVertex2f(5, 5);

        gl.glVertex2f(-15, 15);
        gl.glVertex2f(-5, 5);

        gl.glVertex2f(-5, -5);
        gl.glVertex2f(-15, -15);

        gl.glVertex2f(5, -5);
        gl.glVertex2f(15, -15);
        gl.glEnd();

        gl.glDisable(GL2.GL_LINE_SMOOTH);
        gl.glEnable(GL2.GL_POINT_SMOOTH);

        gl.glColor3f(0.45f, 0.5f, 0.6f);
        gl.glPointSize(2.0f);
        // gl.glBegin(GL.GL_POINTS);
        //
        //
        // gl.glVertex2i(0, 0);
        // gl.glEnd();
        gl.glDisable(GL2.GL_POINT_SMOOTH);

        gl.glEnable(GL2.GL_TEXTURE);
        gl.glEnable(GL2.GL_LIGHTING);
        gl.glPopMatrix();

        gl.glPopAttrib();
        gl.glMatrixMode(GL2.GL_PROJECTION);
        gl.glPopMatrix();
        gl.glMatrixMode(GL2.GL_MODELVIEW);
        gl.glPopMatrix();

    }

    public void nacrtaj_skybox(GLAutoDrawable glad, int golemina) {
        final GL2 gl = glad.getGL().getGL2();

        gl.glDisable(GL2.GL_LIGHTING);
        gl.glEnable(GL2.GL_TEXTURE_2D);

        gl.glColor3f(0.8f, 0.8f, 0.8f);

        gl.glPushMatrix();
        gl.glTranslatef(-golemina / 2, -golemina / 2, -golemina / 2);

        gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[2]);
        gl.glBegin(GL2.GL_QUADS);
        gl.glTexCoord2f(1, 0);
        gl.glVertex3i(0, 0, 0); // predna
        gl.glTexCoord2f(1, 1);
        gl.glVertex3i(0, golemina, 0);
        gl.glTexCoord2f(0, 1);
        gl.glVertex3i(golemina, golemina, 0);
        gl.glTexCoord2f(0, 0);
        gl.glVertex3i(golemina, 0, 0);
        gl.glEnd();

        gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[0]);
        gl.glBegin(GL2.GL_QUADS);
        gl.glTexCoord2f(0, 0);
        gl.glVertex3i(0, 0, golemina); // zadna
        gl.glTexCoord2f(0, 1);
        gl.glVertex3i(0, golemina, golemina);
        gl.glTexCoord2f(1, 1);
        gl.glVertex3i(golemina, golemina, golemina);
        gl.glTexCoord2f(1, 0);
        gl.glVertex3i(golemina, 0, golemina);
        gl.glEnd();

        gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[3]);
        gl.glBegin(GL2.GL_QUADS);
        gl.glTexCoord2f(0, 0);
        gl.glVertex3i(0, 0, 0); // levo
        gl.glTexCoord2f(1, 0);
        gl.glVertex3i(0, 0, golemina);
        gl.glTexCoord2f(1, 1);
        gl.glVertex3i(0, golemina, golemina);
        gl.glTexCoord2f(0, 1);
        gl.glVertex3i(0, golemina, 0);
        gl.glEnd();

        gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[4]);
        gl.glBegin(GL2.GL_QUADS);
        gl.glTexCoord2f(1, 0);
        gl.glVertex3i(golemina, 0, 0); // desno
        gl.glTexCoord2f(0, 0);
        gl.glVertex3i(golemina, 0, golemina);
        gl.glTexCoord2f(0, 1);
        gl.glVertex3i(golemina, golemina, golemina);
        gl.glTexCoord2f(1, 1);
        gl.glVertex3i(golemina, golemina, 0);
        gl.glEnd();

        gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[1]);
        gl.glBegin(GL2.GL_QUADS);
        gl.glTexCoord2f(1, 0);
        gl.glVertex3i(0, 0, 0);// dole
        gl.glTexCoord2f(1, 1);
        gl.glVertex3i(golemina, 0, 0);
        gl.glTexCoord2f(0, 1);
        gl.glVertex3i(golemina, 0, golemina);
        gl.glTexCoord2f(0, 0);
        gl.glVertex3i(0, 0, golemina);
        gl.glEnd();

        gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[5]);
        gl.glBegin(GL2.GL_QUADS);
        gl.glTexCoord2f(1, 1);
        gl.glVertex3i(0, golemina, 0);// gore
        gl.glTexCoord2f(1, 0);
        gl.glVertex3i(golemina, golemina, 0);
        gl.glTexCoord2f(0, 0);
        gl.glVertex3i(golemina, golemina, golemina);
        gl.glTexCoord2f(0, 1);
        gl.glVertex3i(0, golemina, golemina);
        gl.glEnd();

        gl.glPopMatrix();
        gl.glEnable(GL2.GL_LIGHTING);
        gl.glDisable(GL2.GL_TEXTURE_2D);
    }

    public void startDebuger(GLAutoDrawable glad) {
        final GL2 gl = glad.getGL().getGL2();

        IDebugDraw debug = new IDebugDraw() {

            @Override
            public void drawLine(Vector3f vctrf, Vector3f vctrf1, Vector3f vctrf2) {
                gl.glColor3f(vctrf2.x, vctrf2.y, vctrf2.z);
                gl.glBegin(GL.GL_LINES);
                gl.glVertex3f(vctrf.x, vctrf.y, vctrf.z);
                gl.glVertex3f(vctrf1.x, vctrf1.y, vctrf1.z);
                gl.glEnd();
            }

            @Override
            public void drawContactPoint(Vector3f vctrf, Vector3f vctrf1, float f, int i, Vector3f vctrf2) {
                throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
            }

            @Override
            public void reportErrorWarning(String string) {
                throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
            }

            @Override
            public void draw3dText(Vector3f vctrf, String string) {
                throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
            }

            @Override
            public void setDebugMode(int i) {
                throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
            }

            @Override
            public int getDebugMode() {
                return 1;

            }
        };
        dynamicsWorld.setDebugDrawer(debug);

    }

    public void nacrtaj_pod(GLAutoDrawable glad) {
        final GL2 gl = glad.getGL().getGL2();

        gl.glColor3f(0.3f, 0.4f, 0.8f);

        gl.glBegin(GL2.GL_QUADS);
        gl.glNormal3f(0, 1, 0);
        for (int i = 0; i < 20; i++) {
            for (int j = 0; j < 6; j++) {
                gl.glTexCoord2f(i / 20.0f, j / 6.0f);
                gl.glVertex3f(i, 0.0f, j);
                gl.glTexCoord2f((i + 1) / 20.0f, j / 6.0f);
                gl.glVertex3f(i + 1, 0.0f, j);
                gl.glTexCoord2f((i + 1) / 20.0f, (j + 1) / 6.0f);
                gl.glVertex3f(i + 1, 0.0f, j + 1);
                gl.glTexCoord2f(i / 20.0f, (j + 1) / 6.0f);
                gl.glVertex3f(i, 0.0f, j + 1);
            }
        }
        gl.glEnd();
    }

    public void nacrtaj_Koord_Sistem(GLAutoDrawable glad) {
        final GL2 gl = glad.getGL().getGL2();

        gl.glColor3f(1.0f, 0.0f, 0.0f);

        gl.glBegin(GL2.GL_LINES);

        gl.glVertex3f(0, 0.0f, 0);// x
        gl.glVertex3f(1, 0.0f, 0);

        gl.glEnd();

        gl.glBegin(GL2.GL_LINES);
        gl.glColor3f(0.0f, 1.0f, 0.0f);
        gl.glVertex3f(0, 0.0f, 0);// y
        gl.glVertex3f(0, 1.0f, 0);
        gl.glEnd();

        gl.glBegin(GL2.GL_LINES);
        gl.glColor3f(0.0f, 0.0f, 1.0f);
        gl.glVertex3f(0, 0.0f, 0);// z
        gl.glVertex3f(0, 0.0f, 1);
        gl.glEnd();

    }

    private void nacrtajKocka(GLAutoDrawable glad) {
        final GL2 gl = glad.getGL().getGL2();

        gl.glPushMatrix();
        gl.glTranslatef(-0.5f, -0.5f, -0.5f);//mora da se vrati za pola zaradi halfextends..
        gl.glBegin(GL2.GL_QUADS);
        gl.glVertex3i(0, 0, 0); // predna
        gl.glVertex3i(0, 1, 0);
        gl.glVertex3i(1, 1, 0);
        gl.glVertex3i(1, 0, 0);
        gl.glEnd();

        gl.glBegin(GL2.GL_QUADS);
        gl.glVertex3i(0, 0, 1); // zadna
        gl.glVertex3i(0, 1, 1);
        gl.glVertex3i(1, 1, 1);
        gl.glVertex3i(1, 0, 1);
        gl.glEnd();

        gl.glBegin(GL2.GL_QUADS);
        gl.glVertex3i(0, 0, 0); // levo
        gl.glVertex3i(0, 0, 1);
        gl.glVertex3i(0, 1, 1);
        gl.glVertex3i(0, 1, 0);
        gl.glEnd();

        gl.glBegin(GL2.GL_QUADS);
        gl.glVertex3i(1, 0, 0); // desno
        gl.glVertex3i(1, 0, 1);
        gl.glVertex3i(1, 1, 1);
        gl.glVertex3i(1, 1, 0);
        gl.glEnd();

        gl.glBegin(GL2.GL_QUADS);
        gl.glVertex3i(0, 0, 0);// dole
        gl.glVertex3i(1, 0, 0);
        gl.glVertex3i(1, 0, 1);
        gl.glVertex3i(0, 0, 1);
        gl.glEnd();

        gl.glBegin(GL2.GL_QUADS);
        gl.glVertex3i(0, 1, 0);// gore
        gl.glVertex3i(1, 1, 0);
        gl.glVertex3i(1, 1, 1);
        gl.glVertex3i(0, 1, 1);
        gl.glEnd();
        gl.glPopMatrix();
    }

    public void nacrtajPuska(GLAutoDrawable glad) {
        final GL2 gl = glad.getGL().getGL2();

        gl.glColor3f(0.8f, 0.8f, 0.8f);
        gl.glBegin(GL2.GL_QUADS);
        gl.glVertex3f(0, 0, 0); // predna
        gl.glVertex3f(0, 0.2f, 0);
        gl.glVertex3f(0.2f, 0.2f, 0);
        gl.glVertex3f(0.2f, 0, 0);
        gl.glEnd();

        gl.glBegin(GL2.GL_QUADS);
        gl.glVertex3f(0, 0, 0.2f); // zadna
        gl.glVertex3f(0, 0.2f, 0.2f);
        gl.glVertex3f(0.2f, 0.2f, 0.2f);
        gl.glVertex3f(0.2f, 0, 0.2f);
        gl.glEnd();

        gl.glBegin(GL2.GL_QUADS);
        gl.glVertex3f(0, 0, 0); // levo
        gl.glVertex3f(0, 0, 1);
        gl.glVertex3f(0, 0.2f, 1);
        gl.glVertex3f(0, 0.2f, 0);
        gl.glEnd();

        gl.glBegin(GL2.GL_QUADS);
        gl.glVertex3f(0.2f, 0, 0); // desno
        gl.glVertex3f(0.2f, 0, 1);
        gl.glVertex3f(0.2f, 0.2f, 1);
        gl.glVertex3f(0.2f, 0.2f, 0);
        gl.glEnd();

        gl.glBegin(GL2.GL_QUADS);
        gl.glVertex3f(0, 0, 0);// dole
        gl.glVertex3f(0.2f, 0, 0);
        gl.glVertex3f(0.2f, 0, 1);
        gl.glVertex3f(0, 0, 1);
        gl.glEnd();

        gl.glBegin(GL2.GL_QUADS);
        gl.glVertex3f(0, 0.2f, 0);// gore
        gl.glVertex3f(0.2f, 0.2f, 0);
        gl.glVertex3f(0.2f, 0.2f, 1);
        gl.glVertex3f(0, 0.2f, 1);
        gl.glEnd();

    }

    private void nacrtajDzid(GLAutoDrawable glad, float f, float f0, float f1) {
        final GL2 gl = glad.getGL().getGL2();

        float x = f * 2;
        float y = f0 * 2;
        float z = f1 * 2;

//        System.out.println(x + " " + y + " " + z);
        gl.glPushMatrix();
        gl.glTranslatef(-f, -f0, -f1);//mora da se vrati za pola zaradi halfextends..
        gl.glBegin(GL2.GL_QUADS);
        gl.glVertex3f(0, 0, 0); // predna
        gl.glVertex3f(0, y, 0);
        gl.glVertex3f(x, y, 0);
        gl.glVertex3f(x, 0, 0);
        gl.glEnd();

        gl.glBegin(GL2.GL_QUADS);
        gl.glVertex3f(0, 0, z); // zadna
        gl.glVertex3f(0, y, z);
        gl.glVertex3f(x, y, z);
        gl.glVertex3f(x, 0, z);
        gl.glEnd();

        gl.glBegin(GL2.GL_QUADS);
        gl.glVertex3f(0, 0, 0); // levo
        gl.glVertex3f(0, 0, z);
        gl.glVertex3f(0, y, z);
        gl.glVertex3f(0, y, 0);
        gl.glEnd();

        gl.glBegin(GL2.GL_QUADS);
        gl.glVertex3f(x, 0, 0); // desno
        gl.glVertex3f(x, 0, z);
        gl.glVertex3f(x, y, z);
        gl.glVertex3f(x, y, 0);
        gl.glEnd();

        gl.glBegin(GL2.GL_QUADS);
        gl.glVertex3f(0, 0, 0);// dole
        gl.glVertex3f(x, 0, 0);
        gl.glVertex3f(x, 0, z);
        gl.glVertex3f(0, 0, z);
        gl.glEnd();

        gl.glBegin(GL2.GL_QUADS);
        gl.glVertex3f(0, y, 0);// gore
        gl.glVertex3f(x, y, 0);
        gl.glVertex3f(x, y, z);
        gl.glVertex3f(0, y, z);
        gl.glEnd();
        gl.glPopMatrix();
    }

    public void playerPhysics() {
//        CollisionShape kocka_colision_shape = new CylinderShape(new Vector3f(0.5f, 0.5f, 0.5f));
        CollisionShape kocka_colision_shape = new BoxShape(new Vector3f(0.5f, 0.5f, 0.5f));
        MotionState kocka_state = new DefaultMotionState(new Transform(new Matrix4f(new Quat4f(0, 0, 0, 1), new Vector3f(0, 2, 0), 1.0f)));
        Vector3f kocka_inercija = new Vector3f(0, 0, 0);
        kocka_colision_shape.calculateLocalInertia(1.0f, kocka_inercija);
        RigidBodyConstructionInfo kocka_info = new RigidBodyConstructionInfo(1.0f, kocka_state, kocka_colision_shape, kocka_inercija);
        kocka_info.restitution = 0.1f;
        player = new RigidBody(kocka_info);
        player.setAngularFactor(0.0f);
        player.setFriction(0.0f);
        player.setActivationState(CollisionObject.DISABLE_DEACTIVATION);
        dynamicsWorld.addRigidBody(player);
    }

    public void setUpPhysics() {
        //svet
        BroadphaseInterface broadface = new DbvtBroadphase();
        CollisionConfiguration configuration = new DefaultCollisionConfiguration();
        CollisionDispatcher dispacher = new CollisionDispatcher(configuration);
        SequentialImpulseConstraintSolver solver = new SequentialImpulseConstraintSolver();
        dynamicsWorld = new DiscreteDynamicsWorld(dispacher, broadface, solver, configuration);
        dynamicsWorld.setGravity(new Vector3f(0, -3, 0));

        //pod
        CollisionShape pod_colision_shape = new StaticPlaneShape(new Vector3f(0.0f, 1.0f, 0.0f), 0.0f);
        MotionState pod_state = new DefaultMotionState(new Transform(new Matrix4f(new Quat4f(0, 0, 0, 1), new Vector3f(0, 0, 0), 1.0f)));
        RigidBodyConstructionInfo pod_info = new RigidBodyConstructionInfo(0.0f, pod_state, pod_colision_shape, new Vector3f(0, 0, 0));
        pod_info.friction = 0.4f;
        rigid_body_pod = new RigidBody(pod_info);
        rigid_body_pod.setUserPointer("pod");
        dynamicsWorld.addRigidBody(rigid_body_pod);

        //kocka
        CollisionShape kocka_colision_shape = new BoxShape(new Vector3f(0.5f, 0.5f, 0.5f));
        MotionState kocka_state = new DefaultMotionState(new Transform(new Matrix4f(new Quat4f(0, 0, 0, 1), new Vector3f(4, 3, 4), 1.0f)));
        Vector3f kocka_inercija = new Vector3f(0, 0, 0);
        kocka_colision_shape.calculateLocalInertia(1.0f, kocka_inercija);
        RigidBodyConstructionInfo kocka_info = new RigidBodyConstructionInfo(1.0f, kocka_state, kocka_colision_shape, kocka_inercija);
        kocka_info.restitution = 0.1f;
        // kocka_info.angularDamping = 0.5f;
        rigid_body_kocka = new RigidBody(kocka_info);
        rigid_body_kocka.setCollisionFlags(rigid_body_kocka.getCollisionFlags() | com.bulletphysics.collision.dispatch.CollisionFlags.CUSTOM_MATERIAL_CALLBACK);
        rigid_body_kocka.setActivationState(CollisionObject.DISABLE_DEACTIVATION);
        rigid_body_kocka.setUserPointer("kocka1");
        dynamicsWorld.addRigidBody(rigid_body_kocka);

        //kocka2
        CollisionShape kocka2_shape = new BoxShape(new Vector3f(0.5f, 0.5f, 0.5f));
        MotionState kocka2_state = new DefaultMotionState(new Transform(new Matrix4f(new Quat4f(0, 0, 0, 1), new Vector3f(4, 5, 4.5f), 1.0f)));
        Vector3f kocka2_inercija = new Vector3f(0, 0, 0);
        kocka2_shape.calculateLocalInertia(1.0f, kocka2_inercija);
        RigidBodyConstructionInfo kocka2_info = new RigidBodyConstructionInfo(1.0f, kocka2_state, kocka2_shape, kocka2_inercija);
        kocka2_info.restitution = 0.2f;
        //kocka2_info.angularDamping = 0.95f;
        rigid_body_kocka2 = new RigidBody(kocka2_info);
        rigid_body_kocka2.setCollisionFlags(rigid_body_kocka2.getCollisionFlags() | com.bulletphysics.collision.dispatch.CollisionFlags.CUSTOM_MATERIAL_CALLBACK); //dodavanje na bajti
        dynamicsWorld.addRigidBody(rigid_body_kocka2);
        rigid_body_kocka2.setUserPointer("kocka2");

        CollisionShape dzid_shape = new BoxShape(new Vector3f(1.0f, 1.0f, 2.5f));
        MotionState dzid_state = new DefaultMotionState(new Transform(new Matrix4f(new Quat4f(0, 0, 0, 1), new Vector3f(5, 1.0f, 1), 1.0f)));
        Vector3f dzid_inercija = new Vector3f(0, 0, 0);
        dzid_shape.calculateLocalInertia(0.0f, dzid_inercija);
        RigidBodyConstructionInfo dzid_info = new RigidBodyConstructionInfo(0.0f, dzid_state, dzid_shape, dzid_inercija);
        dzid = new RigidBody(dzid_info);
        dzid.setCollisionFlags(dzid.getCollisionFlags() | com.bulletphysics.collision.dispatch.CollisionFlags.CUSTOM_MATERIAL_CALLBACK);
        dzid.setActivationState(CollisionObject.DISABLE_DEACTIVATION);
        dzid.setUserPointer("DZID1");
        dynamicsWorld.addRigidBody(dzid);

    }

    @Override
    public void init(GLAutoDrawable glad) {
        final GL2 gl = glad.getGL().getGL2();

        gl.glShadeModel(GL2.GL_SMOOTH);
        gl.glClearColor(0.1f, 0.1f, 0.1f, 0.0f);
        gl.glClearDepth(1.0f);
        gl.glEnable(GL2.GL_DEPTH_TEST);
        gl.glDepthFunc(GL2.GL_LEQUAL);
        gl.glHint(GL2.GL_PERSPECTIVE_CORRECTION_HINT, GL2.GL_NICEST);

        // svetlo
        float[] lightAmbient = {0.5f, 0.5f, 0.5f, 1.0f};
        float[] lightDiffuse = {1.0f, 1.0f, 1.0f, 1.0f};
        float[] lightPosition = {4.0f, 10.0f, 4.0f, 1.0f};

        gl.glLightfv(GL2.GL_LIGHT1, GL2.GL_AMBIENT, lightAmbient, 0);
        gl.glLightfv(GL2.GL_LIGHT1, GL2.GL_DIFFUSE, lightDiffuse, 0);
        gl.glLightfv(GL2.GL_LIGHT1, GL2.GL_POSITION, lightPosition, 0);

        gl.glEnable(GL2.GL_LIGHT1);
        gl.glEnable(GL2.GL_LIGHTING);

        // tekstura
        gl.glEnable(GL2.GL_TEXTURE_2D);
        try {
            skybox_texture = new int[6];
            File file = new File("resources/skybox/toh_bk.tga");
            Texture t = TextureIO.newTexture(file, true);
            skybox_texture[0] = t.getTextureObject(gl);
            gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MAG_FILTER,
                    GL2.GL_LINEAR);
            gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MIN_FILTER,
                    GL2.GL_LINEAR);
            gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[0]);

            file = new File("resources/skybox/toh_dn.tga");
            t = TextureIO.newTexture(file, true);
            skybox_texture[1] = t.getTextureObject(gl);
            gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MAG_FILTER,
                    GL2.GL_LINEAR);
            gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MIN_FILTER,
                    GL2.GL_LINEAR);
            gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[1]);

            file = new File("resources/skybox/toh_ft.tga");
            t = TextureIO.newTexture(file, true);
            skybox_texture[2] = t.getTextureObject(gl);
            gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MAG_FILTER,
                    GL2.GL_LINEAR);
            gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MIN_FILTER,
                    GL2.GL_LINEAR);
            gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[2]);

            file = new File("resources/skybox/toh_lf.tga");
            t = TextureIO.newTexture(file, true);
            skybox_texture[3] = t.getTextureObject(gl);
            gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MAG_FILTER,
                    GL2.GL_LINEAR);
            gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MIN_FILTER,
                    GL2.GL_LINEAR);
            gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[3]);

            file = new File("resources/skybox/toh_rt.tga");
            t = TextureIO.newTexture(file, true);
            skybox_texture[4] = t.getTextureObject(gl);
            gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MAG_FILTER,
                    GL2.GL_LINEAR);
            gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MIN_FILTER,
                    GL2.GL_LINEAR);
            gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[4]);

            file = new File("resources/skybox/toh_up.tga");
            t = TextureIO.newTexture(file, true);
            skybox_texture[5] = t.getTextureObject(gl);
            gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MAG_FILTER,
                    GL2.GL_LINEAR);
            gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_MIN_FILTER,
                    GL2.GL_LINEAR);
            gl.glBindTexture(GL2.GL_TEXTURE_2D, skybox_texture[5]);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dispose(GLAutoDrawable glad) {
        final GL2 gl = glad.getGL().getGL2();
    }

    @Override
    public void display(GLAutoDrawable glad) {
        final GL2 gl = glad.getGL().getGL2();
        gl.glClear(GL2.GL_COLOR_BUFFER_BIT | GL2.GL_DEPTH_BUFFER_BIT);
        gl.glLoadIdentity();

        if (fizika) {
            setUpPhysics();
            playerPhysics();
            fizika = false;
        }

        float movevel = 0.004f;
        if (c.W) {
            if (c.camPitch != 90 && c.camPitch != -90) // if we are facing
            // directly up or down,
            // we don't go forward,
            // it will be commented
            // out, when there will
            // be gravity
            {
                c.moveCamera(movevel, 0.0f); // move forward

            }
            c.moveCameraUp(movevel, 0.0f); // move up/down

        }
        if (c.S) {
            // same, just we use 180 degrees, so we move at the different
            // direction (move back)
            if (c.camPitch != 90 && c.camPitch != -90) {
                c.moveCamera(movevel, 180.0f);
            }
            c.moveCameraUp(movevel, 180.0f);
        }
        if (c.D) {
            c.moveCamera(movevel, 90.0f);
        }
        if (c.A) {
            c.moveCamera(movevel, 270.0f);
        }
        c.lookVectorCamera();

        movePlayer(player);

        glu.gluLookAt(0, 0, 0, 0, 0, 1, 0, 1, 0);

//        	System.out.println("Koordinati na igrac X=" + -c.camX + " Y=" + -c.camY
//        			+ " Z=" + -c.camZ);
        Vector3f poz = player.getWorldTransform(new Transform()).origin;

        gl.glRotatef(-c.camPitch, 1.0f, 0.0f, 0.0f);
        gl.glRotatef(c.camYaw, 0.0f, 1.0f, 0.0f);
        //  nacrtaj_skybox(glad, 40);
        gl.glTranslatef(-poz.x, -poz.y, -poz.z); //KAMERA NA IGRAC
//        gl.glTranslatef(-c.camX, -c.camY, -c.camZ); //KAMERA SPECTATOR

        gl.glBegin(GL2.GL_LINES);
        gl.glVertex3f(poz.x - 0.5f, poz.y, poz.z - 0.5f); // zadna
        gl.glVertex3f(poz.x - 0.5f, -100, poz.z - 0.5f);

        gl.glVertex3f(poz.x - 0.5f, poz.y, poz.z + 0.5f); // zadna
        gl.glVertex3f(poz.x - 0.5f, -100, poz.z + 0.5f);

        gl.glVertex3f(poz.x + 0.5f, poz.y, poz.z - 0.5f); // zadna
        gl.glVertex3f(poz.x + 0.5f, -100, poz.z - 0.5f);

        gl.glVertex3f(poz.x + 0.5f, poz.y, poz.z + 0.5f); // zadna
        gl.glVertex3f(poz.x + 0.5f, -100, poz.z + 0.5f);
        gl.glEnd();

        gl.glPushMatrix();//crtanje player
        Transform tp = new Transform();
        player.getWorldTransform(tp);
        float[] matp = new float[16];
        tp.getOpenGLMatrix(matp);
        gl.glMultMatrixf(matp, 0);
//        nacrtajKocka(glad); //treba da se crta ako e spectator
        gl.glPopMatrix();

        gl.glPushMatrix();
        Transform t0 = new Transform();
        rigid_body_pod.getWorldTransform(t0);
        float[] matrix_pod = new float[16];
        t0.getOpenGLMatrix(matrix_pod);
        gl.glMultMatrixf(matrix_pod, 0);
        nacrtaj_pod(glad);
        gl.glPopMatrix();

        //  System.out.println(rigid_body_pod.getWorldTransform(new Transform()).origin.toString());
        gl.glPushMatrix();//crtanje kocka
        Transform t1 = new Transform();
        rigid_body_kocka.getWorldTransform(t1);
        float[] mat = new float[16];
        t1.getOpenGLMatrix(mat);
        gl.glMultMatrixf(mat, 0);
        //  System.out.println(kocka_pozicija.toString());
        nacrtajKocka(glad);
        nacrtaj_Koord_Sistem(glad);
        gl.glPopMatrix();

        gl.glPushMatrix();//crtanje kocka2
        Transform t2 = new Transform();
        rigid_body_kocka2.getWorldTransform(t2);
        float[] mat2 = new float[16];
        t2.getOpenGLMatrix(mat2);
        gl.glMultMatrixf(mat2, 0);
        nacrtajKocka(glad);
        gl.glPopMatrix();

        if (c.Space) {
            ID++;
            CollisionShape k_shape = new BoxShape(new Vector3f(0.5f, 0.5f, 0.5f));
            MotionState k_state = new DefaultMotionState(new Transform(new Matrix4f(new Quat4f(0, 0, 0, 1), new Vector3f(c.camX, c.camY, c.camZ), 1.0f)));
            Vector3f k_inercija = new Vector3f(0, 0, 0);
            k_shape.calculateLocalInertia(4.0f, k_inercija);
            RigidBodyConstructionInfo k_info = new RigidBodyConstructionInfo(4.0f, k_state, k_shape, k_inercija);
            k_info.friction = 0.8f;
            RigidBody k = new RigidBody(k_info);
            k.setCollisionFlags(k.getCollisionFlags() | com.bulletphysics.collision.dispatch.CollisionFlags.CUSTOM_MATERIAL_CALLBACK);
            dynamicsWorld.addRigidBody(k);
            k.setLinearVelocity(new Vector3f(c.camX_look_vector * 10, c.camY_look_vector * 10, c.camZ_look_vector * 10));
            bodies.add(new BulletObject(ID, 0.1f, 0.5f, 0.1f, k));
            k.setUserPointer(bodies.get(bodies.size() - 1));
            //   System.out.println(k.getUserPointer());
            // System.out.println(ID);

            c.Space = false;
        }

//        gl.glPushMatrix();
//        gl.glTranslatef(c.camX_look, c.camY_look, c.camZ_look);
//        nacrtajPuska(glad);
//        gl.glPopMatrix();
        for (BulletObject body : bodies) {
            gl.glPushMatrix();
            //   body.setLinearVelocity(new Vector3f(1, 1, 1));
            Transform t = new Transform();
            body.body.getWorldTransform(t);
            float[] matrix = new float[16];
            t.getOpenGLMatrix(matrix);
            gl.glMultMatrixf(matrix, 0);
            gl.glColor3f(body.r, body.b, body.g);
            nacrtajKocka(glad);
            gl.glPopMatrix();
        }

        gl.glPushMatrix();
        Transform t = new Transform();
        dzid.getWorldTransform(t);
        float[] matrix = new float[16];
        t.getOpenGLMatrix(matrix);
        gl.glMultMatrixf(matrix, 0);
        nacrtajDzid(glad, 1.0f, 1.0f, 2.5f);
        gl.glPopMatrix();

        //    System.out.println("Broj na kolizii: " + dynamicsWorld.getDispatcher().getNumManifolds() + " broj na kocki: " + (ID + 2));
        int br_kolizii = dynamicsWorld.getDispatcher().getNumManifolds();

        for (int i = 0; i < br_kolizii; i++) {
            PersistentManifold pm = dynamicsWorld.getDispatcher().getManifoldByIndexInternal(i);

            //    System.out.println(((RigidBody) pm.getBody0()).getUserPointer());
            //    System.out.println(((RigidBody) pm.getBody1()).getUserPointer());
        }

        if (c.Pucaj) {
            ClosestRayResultCallback ray = new ClosestRayResultCallback(new Vector3f(c.camX, c.camY, c.camZ), new Vector3f(c.camX_look_vector * 1000, c.camY_look_vector * 1000, c.camZ_look_vector * 1000));
            dynamicsWorld.rayTest(new Vector3f(c.camX, c.camY, c.camZ), new Vector3f(c.camX_look_vector * 1000, c.camY_look_vector * 1000, c.camZ_look_vector * 1000), ray);

            if (ray.hasHit()) {
                System.out.println(ray.collisionObject.getUserPointer());
            }
        }

        nacrtaj_kursor(glad);
        dynamicsWorld.stepSimulation(1.0f / 100.0f);

        gl.glFlush();

    }

    @Override
    public void reshape(GLAutoDrawable glad, int x, int y, int width, int height) {

        final GL2 gl = glad.getGL().getGL2();
        if (height <= 0) {
            height = 1;
        }
        final float h = (float) width / (float) height;
        gl.glViewport(0, 0, width, height);
        gl.glMatrixMode(GL2.GL_PROJECTION);
        gl.glLoadIdentity();
        glu.gluPerspective(45.0f, h, 0.2, 100.0);
        gl.glMatrixMode(GL2.GL_MODELVIEW);
        gl.glLoadIdentity();

    }

    public static void main(String[] args) {
        final GLProfile profile = GLProfile.get(GLProfile.GL2);
        GLCapabilities capabilities = new GLCapabilities(profile);

        final GLCanvas canvas = new GLCanvas(capabilities);
        skok jp = new skok();

        canvas.addGLEventListener(jp);
        canvas.setSize(800, 800);

        final Animator animator = new Animator(canvas);

        JFrame frame = new JFrame("PROEKT");
        frame.getContentPane().add(canvas);

        // fullscreen na cela igra
        // frame.setUndecorated(true);
        // frame.setExtendedState(Frame.MAXIMIZED_BOTH);
        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                if (animator.isStarted()) {
                    // prakja poraka kraj i gasi konekcii
                    animator.stop();
                }
                System.exit(0);
            }
        });

        frame.setSize(frame.getContentPane().getPreferredSize());

        graphic_enviroment = GraphicsEnvironment.getLocalGraphicsEnvironment();

        GraphicsDevice[] devices = graphic_enviroment.getScreenDevices();

        /*	for (GraphicsDevice graphicsDevice : devices) {
         System.out.println(graphicsDevice.toString());
         }*/
        dm_old = devices[0].getDisplayMode();
        dm = dm_old;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

        int windowX = Math.max(0, (screenSize.width - frame.getWidth()) / 2);
        int windowY = Math.max(0, (screenSize.height - frame.getHeight()) / 2);

        frame.setLocation(windowX, windowY);
        frame.setVisible(true);

        JPanel p = new JPanel();
        p.setPreferredSize(new Dimension(0, 0));
        frame.add(p, BorderLayout.SOUTH);

        c = new Camera(canvas);
        canvas.addMouseMotionListener(c);
        canvas.addKeyListener(c);
        canvas.addMouseListener(c);

        animator.start();
    }

    private void movePlayer(RigidBody player) {//treba cilindar da e ama ke ima 4 rays nadole za skok (rays ga obikoluev cilindar)
        Vector3f sila = new Vector3f(0, 0, 0);
        float brzina = 3.5f;
        boolean vo_vozduh = false;

        boolean moze_da_skokne = false;
        Vector3f pozicija_igrac = player.getWorldTransform(new Transform()).origin;

        ClosestRayResultCallback ray = new ClosestRayResultCallback(new Vector3f(pozicija_igrac.x - 0.5f, pozicija_igrac.y, pozicija_igrac.z - 0.5f), new Vector3f(pozicija_igrac.x - 0.5f, -20, pozicija_igrac.z - 0.5f));
        dynamicsWorld.rayTest(new Vector3f(pozicija_igrac.x - 0.5f, pozicija_igrac.y, pozicija_igrac.z - 0.5f), new Vector3f(pozicija_igrac.x - 0.5f, -20, pozicija_igrac.z - 0.5f), ray);
        float dalecina = Math.abs(ray.hitPointWorld.y - (pozicija_igrac.y - 0.5f));

        ClosestRayResultCallback ray2 = new ClosestRayResultCallback(new Vector3f(pozicija_igrac.x - 0.5f, pozicija_igrac.y, pozicija_igrac.z + 0.5f), new Vector3f(pozicija_igrac.x - 0.5f, -20, pozicija_igrac.z + 0.5f));
        dynamicsWorld.rayTest(new Vector3f(pozicija_igrac.x - 0.5f, pozicija_igrac.y, pozicija_igrac.z + 0.5f), new Vector3f(pozicija_igrac.x - 0.5f, -20, pozicija_igrac.z + 0.5f), ray2);
        float dalecina2 = Math.abs(ray2.hitPointWorld.y - (pozicija_igrac.y - 0.5f));

        ClosestRayResultCallback ray3 = new ClosestRayResultCallback(new Vector3f(pozicija_igrac.x + 0.5f, pozicija_igrac.y, pozicija_igrac.z - 0.5f), new Vector3f(pozicija_igrac.x + 0.5f, -20, pozicija_igrac.z - 0.5f));
        dynamicsWorld.rayTest(new Vector3f(pozicija_igrac.x + 0.5f, pozicija_igrac.y, pozicija_igrac.z - 0.5f), new Vector3f(pozicija_igrac.x + 0.5f, -20, pozicija_igrac.z - 0.5f), ray3);
        float dalecina3 = Math.abs(ray3.hitPointWorld.y - (pozicija_igrac.y - 0.5f));

        ClosestRayResultCallback ray4 = new ClosestRayResultCallback(new Vector3f(pozicija_igrac.x + 0.5f, pozicija_igrac.y, pozicija_igrac.z + 0.5f), new Vector3f(pozicija_igrac.x + 0.5f, -20, pozicija_igrac.z + 0.5f));
        dynamicsWorld.rayTest(new Vector3f(pozicija_igrac.x + 0.5f, pozicija_igrac.y, pozicija_igrac.z + 0.5f), new Vector3f(pozicija_igrac.x + 0.5f, -20, pozicija_igrac.z + 0.5f), ray4);
        float dalecina4 = Math.abs(ray4.hitPointWorld.y - (pozicija_igrac.y - 0.5f));

        boolean rayce = false;
        boolean rayce2 = false;
        boolean rayce3 = false;
        boolean rayce4 = false;

        if (ray.hasHit() && dalecina <= 0.1f) {
            rayce = true;
        }
        if (ray2.hasHit() && dalecina2 <= 0.1f) {
            rayce2 = true;
        }
        if (ray3.hasHit() && dalecina3 <= 0.1f) {
            rayce3 = true;
        }
        if (ray4.hasHit() && dalecina4 <= 0.1f) {
            rayce4 = true;
        }

        if (rayce || rayce2 || rayce3 || rayce4) {
            moze_da_skokne = true;
        } else {
            vo_vozduh = true;
        }

        if (c.JUMP == 0) {
            if (moze_da_skokne) {
                player.setLinearVelocity(new Vector3f(player.getLinearVelocity(new Vector3f()).x, 3, player.getLinearVelocity(new Vector3f()).z));
            }
            c.JUMP = 1;
        }

        if (c.UP == 0) {
            c.PlayerMove(0);
            sila.add(new Vector3f(c.player_move_x * brzina, 0, c.player_move_z * brzina));
        }
        if (c.UP == 1) {

        }
        if (c.UP == 2) {

        }
        if (c.DOWN == 0) {
            c.PlayerMove(180);
            sila.add(new Vector3f(c.player_move_x * brzina, 0, c.player_move_z * brzina));
        }
        if (c.DOWN == 1) {

        }
        if (c.DOWN == 2) {
            //ne pravi nisto
        }
        if (c.LEFT == 0) {
            c.PlayerMove(-90);
            sila.add(new Vector3f(c.player_move_x * brzina, 0, c.player_move_z * brzina));
        }
        if (c.LEFT == 1) {

            c.LEFT = 2;
        }
        if (c.LEFT == 2) {
            //ne pravi nisto
        }
        if (c.RIGHT == 0) {
            c.PlayerMove(90);
            sila.add(new Vector3f(c.player_move_x * brzina, 0, c.player_move_z * brzina));
        }
        if (c.RIGHT == 1) {

            c.RIGHT = 2;
        }
        if (c.RIGHT == 2) {
            //ne pravi nisto
        }

        if (c.UP == 0 || c.DOWN == 0 || c.LEFT == 0 || c.RIGHT == 0) {
            sila.y = player.getLinearVelocity(new Vector3f()).y;
            player.setLinearVelocity(sila);
        } else {
            player.setLinearVelocity(new Vector3f(0, player.getLinearVelocity(new Vector3f()).y, 0));
        }

    }

}
