/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package bbbbb_skok;

/**
 *
 * @author Stekac
 */
import java.awt.*;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.opengl.awt.GLCanvas;

/**
 *
 * @author Stekac
 */
public class Camera implements MouseMotionListener, KeyListener, MouseListener {

    GLCanvas canvas;
    float camYaw = -30.0f; //agol rotacija levo desno
    float camPitch = 0.0f; //agol rotacija gore dole
    float camX = 0.0f;
    float camY = 2.0f;
    float camZ = 0.0f;
    float camX_look_vector = 0.0f;
    float camY_look_vector = 0.0f;
    float camZ_look_vector = 0.0f;
    float player_move_x = 0.0f;
    float player_move_z = 0.0f;
    boolean W = false;
    boolean A = false;
    boolean S = false;
    boolean D = false;
    boolean Space = false;
    boolean Pucaj = false;

    int UP = 2; //0-mrda, 1-prestaniue, 2-nisto
    int DOWN = 2;
    int LEFT = 2;
    int RIGHT = 2;
    int JUMP = 2;

    public Camera(GLCanvas canvas) {
        this.canvas = canvas;
        canvas.requestFocusInWindow();
        BufferedImage cursorImg = new BufferedImage(16, 16, BufferedImage.TYPE_INT_ARGB);
        Cursor blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(
                cursorImg, new Point(0, 0), "blank cursor");
        canvas.setCursor(blankCursor);
    }

    void lockCamera() {
        //set campitch between -90 and 90 and set camyaw between 0 and 360 degrees
        if (camPitch > 90) {
            camPitch = 90;
        }
        if (camPitch < -90) {
            camPitch = -90;
        }
        if (camYaw < 0.0) {
            camYaw += 360.0;
        }
        if (camYaw > 360.0) {
            camYaw -= 360;
        }
    }

    void moveCamera(float dist, float dir) {
        float rad = (float) Math.toRadians(camYaw + dir);
        camX -= Math.sin(rad) * dist;    //calculate the new coorinate, if you don't understand, draw a right triangle with the datas, you have
        camZ += Math.cos(rad) * dist;    //and try to calculate the new coorinate with trigonometric functions, that should help
    }

    void moveCameraUp(float dist, float dir) {
        //the the same, only this time we calculate the y coorinate
        float rad = (float) Math.toRadians(camPitch + dir);
        camY -= Math.sin(rad) * dist;

    }

    public void PlayerMove(int direction) {
        float rad = (float) Math.toRadians(camYaw + direction);
        player_move_x = (float) ((-Math.sin(rad)));
        player_move_z = (float) ((+Math.cos(rad)));
    }

    public void lookVectorCamera() { //nakude gleda (VECTOR!) za primena na sila itn
        float rad_dist = (float) Math.toRadians(camPitch);
        float distanceAZ = (float) Math.cos(rad_dist);

        float rad = (float) Math.toRadians(camYaw);
        camX_look_vector = (float) (distanceAZ * (-Math.sin(rad)));
        camZ_look_vector = (float) (distanceAZ * (+Math.cos(rad)));

        float rad2 = (float) Math.toRadians(camPitch);
        camY_look_vector = (float) (-Math.sin(rad2));

//        System.out.println("agli : [" + camYaw + " " + camPitch + "]");
//        System.out.println("pozicija : [" + camX + " " + camY + " " + camZ + "]");
//        System.out.println("lookvect :[" + camX_look + " " + camY_look + " " + camZ_look + "]\n");
        //za tacna pozicija u koju tacku gleda u prostor
        //camx_look = camX + camX_look_vector
        //znaci momentalna polozba + kude gleda vector
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {

        float delta_x = 0;
        float delta_y = 0;

        int momentalna_y = canvas.getHeight() / 2;
        int momentalna_x = canvas.getWidth() / 2;
        int dvizi_x = canvas.getMousePosition().x;
        int dvizi_y = canvas.getMousePosition().y;

        delta_x = (dvizi_x - momentalna_x);
        delta_y = (dvizi_y - momentalna_y);

        float brzina = 0.05f;
        camYaw += brzina * delta_x;
        camPitch += brzina * delta_y;
        lockCamera();
        lookVectorCamera();

        try {
            Robot r = new Robot();
            Point p = canvas.getLocationOnScreen();
            r.mouseMove(p.x + canvas.getWidth() / 2, p.y + canvas.getHeight() / 2);
        } catch (AWTException ex) {
            Logger.getLogger(Camera.class.getName()).log(Level.SEVERE, null, ex);
        }

        if (delta_x != 0 || delta_y != 0) {
//            //  System.out.println("delta_x =" + delta_x + "  delta_y=" + delta_y);
//            System.out.println("CamYaw =" + camYaw + "  CamPitch=" + camPitch);
        }

    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {

        if (e.getKeyCode() == KeyEvent.VK_W) {
            W = true;
        }
        if (e.getKeyCode() == KeyEvent.VK_S) {
            S = true;
        }
        if (e.getKeyCode() == KeyEvent.VK_A) {
            A = true;
        }
        if (e.getKeyCode() == KeyEvent.VK_D) {
            D = true;
        }
        if (e.getKeyCode() == KeyEvent.VK_SPACE) {
            Space = true;
        }
        if (e.getKeyCode() == KeyEvent.VK_UP) {
            UP = 0;
        }
        if (e.getKeyCode() == KeyEvent.VK_DOWN) {
            DOWN = 0;
        }
        if (e.getKeyCode() == KeyEvent.VK_LEFT) {
            LEFT = 0;
        }
        if (e.getKeyCode() == KeyEvent.VK_RIGHT) {
            RIGHT = 0;
        }
        if (e.getKeyCode() == KeyEvent.VK_NUMPAD0) {
            JUMP = 0;
        }

    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == KeyEvent.VK_W) {
            W = false;
        }
        if (e.getKeyCode() == KeyEvent.VK_S) {
            S = false;
        }
        if (e.getKeyCode() == KeyEvent.VK_A) {
            A = false;
        }
        if (e.getKeyCode() == KeyEvent.VK_D) {
            D = false;
        }
        if (e.getKeyCode() == KeyEvent.VK_SPACE) {
            Space = false;
        }
        if (e.getKeyCode() == KeyEvent.VK_UP) {
            UP = 1;
        }
        if (e.getKeyCode() == KeyEvent.VK_DOWN) {
            DOWN = 1;
        }
        if (e.getKeyCode() == KeyEvent.VK_LEFT) {
            LEFT = 1;
        }
        if (e.getKeyCode() == KeyEvent.VK_RIGHT) {
            RIGHT = 1;
        }
        if (e.getKeyCode() == KeyEvent.VK_NUMPAD0) {
            JUMP = 1;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {

    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.Pucaj = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.Pucaj = false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

}
