package com.db.finki.www.build_board.entity.user_type;

import com.db.finki.www.build_board.entity.compositeId.DeveloperAssociatedWithProjectId;
import com.db.finki.www.build_board.entity.thread.Project;
import jakarta.persistence.*;

import java.time.LocalDateTime;

@Entity
@Table(name = "developer_associated_with_project")
@IdClass(DeveloperAssociatedWithProjectId.class)
public class DeveloperAssociatedWithProject {
    @Id
    @ManyToOne
    @JoinColumn(name = "about_dev")
    private BBUser developer;

    @Id
    @ManyToOne
    @JoinColumn(name = "in_project")
    private Project project;

    @Id
    @Column(name = "started_at")
    private LocalDateTime startedAt;

    @Column(name = "ended_at")
    private LocalDateTime endedAt;
}
