package com.db.finki.www.build_board.entity.thread;

import com.db.finki.www.build_board.entity.blacklisted_user.BlacklistedUser;
import com.db.finki.www.build_board.entity.thread.itf.NamedThread;
import com.db.finki.www.build_board.entity.thread.multi_valued_attribute.Guideline;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.*;
import lombok.*;

import java.util.List;

@Getter
@Setter
@NoArgsConstructor
@Entity
@Table(name = "topic_thread")
public class Topic extends EmbeddableThread implements NamedThread {

    private String title;

    @JsonIgnore
    @OneToMany(mappedBy = "topic")
    private List<Guideline> guidelines;

    @ManyToOne
    @JoinColumn(name = "parent_id")
    private Project parent;

    @OneToMany(mappedBy = "topic")
    private List<BlacklistedUser> blacklistedUsers;

    @Override
    public String getTypeName() {
        return "topics";
    }
}
