# Environment Variables Setup

This project uses environment variables to store sensitive database credentials securely.

## Setup Instructions

1. **Copy the example environment file:**
   ```bash
   cp .env.example .env
   ```

2. **Edit the `.env` file with your actual database credentials:**
   ```bash
   nano .env
   ```

3. **Fill in your database information:**
   ```
   DB_USER=your_database_user
   DB_HOST=localhost
   DB_NAME=your_database_name
   DB_PASSWORD=your_database_password
   DB_PORT=9999
   ```

## Security Notes

- ✅ The `.env` file is included in `.gitignore` and will NOT be committed to git
- ✅ The `.env.example` file shows the required variables without sensitive data
- ✅ Database credentials are no longer hardcoded in the source code

## Available Environment Variables

| Variable | Description | Example |
|----------|-------------|---------|
| `DB_USER` | Database username | `db_202425z_va_prj_carzone_owner` |
| `DB_HOST` | Database host | `localhost` |
| `DB_NAME` | Database name | `db_202425z_va_prj_carzone` |
| `DB_PASSWORD` | Database password | `your_secure_password` |
| `DB_PORT` | Database port | `9999` |

## Running the Application

After setting up your `.env` file, start the application as usual:

```bash
npm install
node index.js
```

The application will automatically load the environment variables from the `.env` file.
