const express = require("express");
var cors = require("cors");
const app = express();
const port = 3001;

app.use(express.json());

app.use(function (req, res, next) {
    res.setHeader("Access-Control-Allow-Origin", "*");
    res.setHeader(
        "Access-Control-Allow-Methods",
        "GET,POST,PUT,DELETE,OPTIONS"
    );
    res.setHeader(
        "Access-Control-Allow-Headers",
        "Content-Type, Access-Control-Allow-Headers"
    );
    next();
});

//connection functions
const connection_model = require("./connectionModel");

//Server requests start here

// For home page all listings
app.get("/", (req, res) => {
    connection_model
        .getVehicles()
        .then((response) => {
            res.status(200).send(response);
        })
        .catch((error) => {
            res.status(500).send(error);
        });
});

// For My list
app.get("/mylist", (req, res) => {
    connection_model
        .getMyVehicles()
        .then((response) => {
            res.status(200).send(response);
        })
        .catch((error) => {
            res.status(500).send(error);
        });
});

// Not implemented
/* app.post("/agreement", (req, res) => {
    connection_model
        .createAgreement(req.body)
        .then((response) => {
            res.status(200).send(response);
        })
        .catch((error) => {
            res.status(500).send(error);
        });
}); */

// For create vehicle POST method
app.post("/createvehicle", (req, res) => {
    connection_model
        .createVehicle(req.body)
        .then((response) => {
            res.status(200).send(response);
        })
        .catch((error) => {
            res.status(500).send(error);
        });
});

// For register new user POST
app.post("/registeruser", (req, res) => {
    connection_model
        .registerUser(req.body)
        .then((response) => {
            res.status(200).send(response);
        })
        .catch((error) => {
            res.status(500).send(error);
        });
});

// To get single agreement based on slug passed
app.get("/agreement/:slug", (req, res) => {
    connection_model
        .getAgreement(req.params.slug)
        .then((response) => {
            res.status(200).send(response);
        })
        .catch((error) => {
            res.status(500).send(error);
        });
});

app.listen(port, () => {
    console.log(`App running on port ${port}.`);
});
