import { Flex, Text, Button } from "@chakra-ui/react";
import { Link } from "react-router-dom";

const SoldBlogCard = ({
    vin,
    vehicle_body,
    car_make,
    car_model,
    p_year,
    capacity,
    power,
    color,
    price,
    status,
}) => {
    return (
        <Flex
            minWidth='400px'
            boxShadow='lg'
            hover={{ boxShadow: "xl" }}
            borderBottomRadius='10px'
            bg='white'
            borderRadius='13px'
            transition='all 0.4s ease'
            padding='20px'
            maxWidth='400px'
            direction='column'
            borderTop='4px'
            borderColor='teal'
            _hover={{ boxShadow: "2xl" }}>
            <Text
                marginBottom='10px'
                fontWeight='bold'
                fontSize='20px'
                align='center'>
                {car_make + " " + car_model}
            </Text>
            <Flex width='100%' height='2px' bg='teal' />
            <Flex
                width='100%'
                justifyItems='center'
                alignItems='center'
                justifyContent='space-around'>
                <Flex
                    direction='column'
                    width='100%'
                    maxWidth='120px'
                    alignItems='center'>
                    <Text fontSize='14px' padding='5px'>
                        {vehicle_body}
                    </Text>
                    <Flex height='2px' bg='teal' width='100%'></Flex>
                    <Text fontSize='14px' padding='5px'>
                        {p_year.slice(1, -1)}
                    </Text>
                </Flex>
                <Flex
                    maxWidth='120px'
                    marginTop='5px'
                    height='90%'
                    width='2px'
                    bg='teal'></Flex>
                <Flex direction='column' alignItems='center'>
                    <Text fontSize='14px' padding='5px'>
                        {capacity}
                    </Text>
                    <Flex height='2px' bg='teal' width='100%'></Flex>
                    <Text fontSize='14px' padding='5px'>
                        {color}
                    </Text>
                </Flex>
            </Flex>
            <Flex marginTop='5px' width='100%' height='2px' bg='teal' />
            <Flex width='100%' justifyContent='center' direction='column'>
                <Text
                    marginTop='10px'
                    fontSize='20px'
                    fontWeight='bold'
                    textAlign='center'
                    justifySelf='right'>
                    {price.slice(1, -1) + "e"}
                </Text>
                <Flex marginTop='5px' justifyContent='space-between'>
                    {status == "false" ? (
                        <Button
                            minW="120px"
                            bg='#004d42'
                            color='white'
                            _hover={{
                                background: "#006b5c",
                            }}>
                            Sold
                        </Button>
                    ) : (
                        <Button
                            bg='#ff4a6e'
                            color='white'
                            _hover={{
                                background: "#fa5c7c",
                            }}>
                            Set as Sold
                        </Button>
                    )}
                    {status == "false" ? (
                        <Link to='../agreement' state={{ vin: vin }}>
                            <Button
                                bg='white'
                                color='black'
                                borderColor='#160085'
                                borderWidth='3px'
                                _hover={{
                                    background: "#160085",
                                    color: "white",
                                }}>
                                See Agreement
                            </Button>
                        </Link>
                    ) : null}
                </Flex>
            </Flex>
        </Flex>
    );
};

export default SoldBlogCard;
