const Pool = require("pg").Pool;
const pool = new Pool({
    // Connect to local postgre server

    /* user: "postgres",
    host: "localhost",
    database: "postgres",
    password: "3533",
    port: 5432, */

    //Connect to live finki postgre server

    user: "db_202324z_va_prj_carzone_owner",
    host: "localhost",
    database: "db_202324z_va_prj_carzone",
    password: "673f77a552e6",
    port: 9999,
});

// Get all vehicles
const getVehicles = async () => {
    try {
        return await new Promise(function (resolve, reject) {
            pool.query(
                "SELECT * from vehicle as v where v.status=true",
                (error, results) => {
                    if (error) {
                        reject(error);
                    }
                    if (results && results.rows) {
                        resolve(results.rows);
                        console.log(results.rows)
                    } else {
                        reject(new Error("No results found"));
                    }
                }
            );
        });
    } catch (error_1) {
        console.error(error_1);
        throw new Error("Internal server error");
    }
    
};

// Get My vehicles
const getMyVehicles = async () => {
    try {
        return await new Promise(function (resolve, reject) {
            pool.query(
                "SELECT * from vehicle where tax_nr=$1",
                ["BM15153"],
                (error, results) => {
                    if (error) {
                        reject(error);
                    }
                    if (results && results.rows) {
                        resolve(results.rows);
                    } else {
                        reject(new Error("No results found"));
                    }
                }
            );
        });
    } catch (error_1) {
        console.error(error_1);
        throw new Error("Internal server error");
    }
};

// Create new vehicle
const createVehicle = async (body) => {
    return new Promise(function (resolve, reject) {
        const {
            vin,
            car_body,
            car_make,
            car_model,
            p_year,
            capacity,
            power,
            color,
            price,
            tax_nr,
        } = body;
        console.log(vin, car_model, p_year);
        pool.query(
            "INSERT INTO vehicle (VIN, Body, Make, Model, P_Year, Capacity, Power, Color, Price, Status, Tax_Nr) values ($1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11) RETURNING *",
            [
                vin,
                car_body,
                car_make,
                car_model,
                p_year,
                capacity,
                power,
                color,
                price,
                true,
                tax_nr
            ],
            (error, results) => {
                if (error) {
                    reject(new Error("Not able to make new vehicle listing."));
                }
                if (results && results.rows) {
                    resolve(`The new vehicle has been entered.`);
                } else {
                    reject(new Error("Not able to make new vehicle listing."));
                }
            }
        );
    });
};

// Register new user
const registerUser = async (body) => {
    return new Promise(function (resolve, reject) {
        const { EMBG, C_name, Email, Pass, Telephone } = body;

        pool.query(
            "INSERT INTO client (EMBG, C_Name, Email, Pass, Telephone) values ($1, $2, $3, $4, $5) RETURNING *",
            [EMBG, C_name, Email, Pass, Telephone],
            (error, results) => {
                if (error) {
                    throw(error);
                }
                if (results && results.rows) {
                    resolve(`Account was created.`);
                } else {
                    throw(new Error("Not able to make new account."));
                }
            }
        );
    });
};

// Get single agreement
const getAgreement = async (slug) => {
    console.log(slug);
    try {
        return await new Promise(function (resolve, reject) {
            pool.query(
                "SELECT * from agreement as a where a.vin=$1",
                [slug],

                (error, results) => {
                    if (error) {
                        reject(error);
                    }
                    if (results && results.rows) {
                        resolve(results.rows);
                    } else {
                        reject(new Error("No results found"));
                    }
                }
            );
        });
    } catch (error_1) {
        console.error(error_1);
        throw new Error("Internal server error");
    }
};

module.exports = {
    getVehicles,
    getMyVehicles,
    createVehicle,
    registerUser,
    getAgreement,
};
