import "./App.css";
import { BrowserRouter, Routes, Route } from "react-router-dom";
import Layout from "./pages/Layout";
import Home from "./pages/Home";
import MyList from "./pages/MyList";
import AddVehicle from "./pages/AddVehicle";
import Agreement from "./pages/Agreement";
import Agreements from "./pages/Agreements";
import RegisterForm from "./pages/RegisterForm";
import { Flex } from "@chakra-ui/react";

function App() {
    return (
        <Flex direction='column'>
            <BrowserRouter>
                <Routes>
                    <Route exact path='/' element={<Layout />}>
                        <Route index element={<Home />} />
                        <Route path='mylist' element={<MyList />} />
                        <Route path='addvehicle' element={<AddVehicle />} />
                        <Route path='registerform' element={<RegisterForm />} />
                        <Route path='agreement' element={<Agreement />} />
                    </Route>
                </Routes>
            </BrowserRouter>
        </Flex>
    );
}

export default App;
