import {
    Box,
    Flex,
    VStack,
    Text,
    HStack,
    StackDivider,
} from "@chakra-ui/react";

const BlogCard = ({
    vin,
    vehicle_body,
    car_make,
    car_model,
    p_year,
    capacity,
    power,
    color,
    price,
    status,
}) => {
    return (
        <Flex
            minWidth='250px'
            boxShadow='lg'
            hover={{ boxShadow: "xl" }}
            borderBottomRadius='10px'
            bg='white'
            borderRadius='13px'
            transition='all 0.4s ease'
            padding='20px'
            maxWidth='250px'
            direction='column'
            borderTop='4px'
            borderColor='teal'
            _hover={{ boxShadow: "2xl" }}>
            <Text
                marginBottom='10px'
                fontWeight='bold'
                fontSize='20px'
                align='center'>
                {car_make + " " + car_model}
            </Text>
            <Flex width='100%' height='2px' bg='teal' />
            <Flex
                justifyItems='center'
                alignItems='center'
                justifyContent='space-around'>
                <Flex
                    direction='column'
                    width='100%'
                    maxWidth='70px'
                    alignItems='center'>
                    <Text fontSize='14px' padding='5px'>
                        {vehicle_body}
                    </Text>
                    <Flex height='2px' bg='teal' width='100%'></Flex>
                    <Text fontSize='14px' padding='5px'>
                        {p_year.slice(1, -1)}
                    </Text>
                </Flex>
                <Flex
                    maxWidth='70px'
                    marginTop='5px'
                    height='90%'
                    width='2px'
                    bg='teal'></Flex>
                <Flex direction='column' alignItems='center'>
                    <Text fontSize='14px' padding='5px'>
                        {capacity}
                    </Text>
                    <Flex height='2px' bg='teal' width='100%'></Flex>
                    <Text fontSize='14px' padding='5px'>
                        {color}
                    </Text>
                </Flex>
            </Flex>
            <Flex marginTop='5px' width='100%' height='2px' bg='teal' />
            <Flex width='100%' justifyContent='center'>
                <Text
                    marginTop='10px'
                    fontSize='20px'
                    fontWeight='bold'
                    textAlign='right'
                    alignSelf='right'
                    justifySelf='right'>
                    {price.slice(1, -1) + "e"}
                </Text>
            </Flex>
        </Flex>
    );
};

export default BlogCard;
