import { useState, useEffect } from "react";
import { Flex, Grid, Button, SimpleGrid, Text } from "@chakra-ui/react";
import BlogCard from "../components/BlogCard";

const Home = () => {
    const [vehicles, setVehicles] = useState(false);
    let tmp = [];

    const getVehicles = () => {
        fetch("http://localhost:3001")
            .then((response) => {
                return response.text();
            })
            .then((data) => {
                setVehicles(data);
            });
    };

    useEffect(() => {
        getVehicles();
    }, []);

    return (
        <Flex width='100%' flexDir='column'>
            <Text
                marginBottom='20px'
                textAlign='center'
                fontWeight='bold'
                fontSize='30px'
                justifySelf='center'>
                All Listings
            </Text>
            <SimpleGrid columns={3} spacing={10} justifyItems='center'>
                <>
                    {vehicles &&
                        vehicles.split(/{(.*?)}/g).map((el, index) => {
                            const holder = el.split(/"*"/);

                            console.log(holder);

                            if (el.length > 10) {
                                return (
                                    <BlogCard
                                        key={index}
                                        vin={holder[3]}
                                        vehicle_body={holder[7]}
                                        car_make={holder[11]}
                                        car_model={holder[15]}
                                        p_year={holder[18]}
                                        capacity={holder[21]}
                                        power={holder[24]}
                                        color={holder[27]}
                                        price={holder[30]}
                                        status={holder[32]}
                                    />
                                );
                            }
                        })}
                </>
            </SimpleGrid>
        </Flex>
    );
};

export default Home;
