import { useState, useEffect } from "react";
import { Flex, Grid, Button, SimpleGrid, Text } from "@chakra-ui/react";
import BlogCard from "../components/BlogCard";

const Home = () => {
    const [vehicles, setVehicles] = useState(false);
    let tmp = [];

    const getVehicles = () => {
        fetch("http://localhost:3001")
            .then((response) => {
                return response.json();
            })
            .then((data) => {
                setVehicles(data);
            });
    };

    useEffect(() => {
        getVehicles();
    }, []);

    return (
        <Flex width='100%' flexDir='column'>
            <Text
                marginBottom='20px'
                textAlign='center'
                fontWeight='bold'
                fontSize='30px'
                justifySelf='center'>
                All Listings
            </Text>
            <SimpleGrid columns={3} spacing={10} justifyItems='center'>
                <>
                    {vehicles &&
                        vehicles.map((vehicle, index) => {
                            return (
                                <BlogCard
                                    key={index}
                                    vin={vehicle.vin}
                                    vehicle_body={vehicle.body}
                                    car_make={vehicle.make}
                                    car_model={vehicle.model}
                                    p_year={vehicle.p_year}
                                    capacity={vehicle.capacity}
                                    power={vehicle.power}
                                    color={vehicle.color}
                                    price={vehicle.price}
                                    status={vehicle.status}
                                />
                            );
                        })}
                </>
            </SimpleGrid>
        </Flex>
    );
};

export default Home;
