import { useState, useEffect } from "react";
import SoldBlogCard from "../components/SoldBlogCard";
import { Button, Flex, SimpleGrid, Text } from "@chakra-ui/react";

const MyList = () => {
    const [myvehicles, setMyVehicles] = useState(false);

    //vin, body, model, p_year, engine, color, price, true, tax_nr
    function createVehicle() {
        let tax_nr = "OB15153";
        let vin = prompt("Enter vehicle VIN");
        let car_body = prompt(
            "Enter vehicle body type (Car, Motorcycle, Van, Truck"
        );
        let car_model = prompt("Enter specific car model");
        let p_year = prompt("Enter vehicle production year");
        let engine = prompt("Enter vehicle engine in displacement");
        let color = prompt("Enter vehicle color (ex. blue, red - lowercase)");
        let price = prompt("Enter vehicle price");
        fetch("http://localhost:3001/createvehicle", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
            },
            body: JSON.stringify({
                vin,
                car_body,
                car_model,
                p_year,
                engine,
                color,
                price,
                tax_nr,
            }),
        }).then((response) => {
            return response.text();
        });
    }

    //Call to get cars of one dealership
    function getMyVehicles() {
        fetch("http://localhost:3001/mylist", {
            credentials: 'include'
        })
            .then((response) => {
                if (response.status === 401) {
                    alert("Please log in as a dealership to view your vehicles");
                    return null;
                }
                return response.json();
            })
            .then((data) => {
                if (data) {
                    setMyVehicles(data);
                }
            });
    }

    useEffect(() => {
        getMyVehicles();
    }, []);

    return (
        <Flex width='100%' flexDir='column' justifyContent='center'>
            <Text
                marginBottom='20px'
                textAlign='center'
                fontWeight='bold'
                fontSize='30px'
                justifySelf='center'>
                Your Listings
            </Text>
            <SimpleGrid columns={2} spacing={10} justifyItems='center'>
                <>
                    {myvehicles &&
                        myvehicles.map((vehicle, index) => {
                            return (
                                <SoldBlogCard
                                    key={index}
                                    vin={vehicle.vin}
                                    vehicle_body={vehicle.body}
                                    car_make={vehicle.make}
                                    car_model={vehicle.model}
                                    p_year={vehicle.p_year}
                                    capacity={vehicle.capacity}
                                    power={vehicle.power}
                                    color={vehicle.color}
                                    price={vehicle.price}
                                    status={vehicle.status}
                                    onVehicleDeleted={getMyVehicles}
                                />
                            );
                        })}
                </>
            </SimpleGrid>
        </Flex>
    );
};

export default MyList;
