const Pool = require("pg").Pool;
const pool = new Pool({
    // Connect to local postgre server

    /* user: "postgres",
    host: "localhost",
    database: "postgres",
    password: "3533",
    port: 5432, */

    //Connect to live finki postgre server

    user: "db_202324z_va_prj_carzone_owner",
    host: "localhost",
    database: "db_202324z_va_prj_carzone",
    password: "673f77a552e6",
    port: 9999,
});

// Get all vehicles
const getVehicles = async () => {
    try {
        return await new Promise(function (resolve, reject) {
            pool.query(
                "SELECT * from vehicle as v where v.status=true",
                (error, results) => {
                    if (error) {
                        reject(error);
                    }
                    if (results && results.rows) {
                        resolve(results.rows);
                        console.log(results.rows)
                    } else {
                        reject(new Error("No results found"));
                    }
                }
            );
        });
    } catch (error_1) {
        console.error(error_1);
        throw new Error("Internal server error");
    }
    
};

// Get My vehicles
const getMyVehicles = async (taxNr) => {
    try {
        return await new Promise(function (resolve, reject) {
            pool.query(
                "SELECT * from vehicle where tax_nr=$1",
                [taxNr],
                (error, results) => {
                    if (error) {
                        reject(error);
                    }
                    if (results && results.rows) {
                        resolve(results.rows);
                    } else {
                        reject(new Error("No results found"));
                    }
                }
            );
        });
    } catch (error_1) {
        console.error(error_1);
        throw new Error("Internal server error");
    }
};

// Create new vehicle
const createVehicle = async (body) => {
    return new Promise(function (resolve, reject) {
        const {
            vin,
            car_body,
            car_make,
            car_model,
            p_year,
            capacity,
            power,
            color,
            price,
            tax_nr,
        } = body;
        console.log(vin, car_model, p_year);
        pool.query(
            "INSERT INTO vehicle (VIN, Body, Make, Model, P_Year, Capacity, Power, Color, Price, Status, Tax_Nr) values ($1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11) RETURNING *",
            [
                vin,
                car_body,
                car_make,
                car_model,
                p_year,
                capacity,
                power,
                color,
                price,
                true,
                tax_nr
            ],
            (error, results) => {
                if (error) {
                    reject(new Error("Not able to make new vehicle listing."));
                }
                if (results && results.rows) {
                    resolve(`The new vehicle has been entered.`);
                } else {
                    reject(new Error("Not able to make new vehicle listing."));
                }
            }
        );
    });
};

// Register new user
const registerUser = async (body) => {
    return new Promise(function (resolve, reject) {
        const { EMBG, C_name, Email, Pass, Telephone } = body;

        pool.query(
            "INSERT INTO client (EMBG, C_Name, Email, Pass, Telephone) values ($1, $2, $3, $4, $5) RETURNING *",
            [EMBG, C_name, Email, Pass, Telephone],
            (error, results) => {
                if (error) {
                    throw(error);
                }
                if (results && results.rows) {
                    resolve(`Account was created.`);
                } else {
                    throw(new Error("Not able to make new account."));
                }
            }
        );
    });
};

// Register new dealership
const registerDealership = async (body) => {
    return new Promise(function (resolve, reject) {
        const { tax_nr, d_name, brands, email, pass, director, telephones, addres } = body;

        pool.query(
            "INSERT INTO dealership (Tax_Nr, D_Name, Brands, Email, Pass, Director, Telephones, Addres) values ($1, $2, $3, $4, $5, $6, $7, $8) RETURNING *",
            [tax_nr, d_name, brands, email, pass, director, telephones, addres],
            (error, results) => {
                if (error) {
                    throw(error);
                }
                if (results && results.rows) {
                    resolve(`Dealership account was created.`);
                } else {
                    throw(new Error("Not able to make new dealership account."));
                }
            }
        );
    });
};

// Get single agreement by VIN
const getAgreement = async (slug) => {
    console.log(slug);
    try {
        return await new Promise(function (resolve, reject) {
            pool.query(
                `SELECT a.*, v.make, v.model, v.p_year, v.color,
                        c.c_name, c.embg, d.d_name
                 FROM agreement a
                 JOIN vehicle v ON a.vin = v.vin
                 JOIN client c ON a.embg = c.embg
                 JOIN dealership d ON a.tax_nr = d.tax_nr
                 WHERE a.vin = $1`,
                [slug],
                (error, results) => {
                    if (error) {
                        reject(error);
                    }
                    if (results && results.rows) {
                        resolve(results.rows);
                    } else {
                        reject(new Error("No results found"));
                    }
                }
            );
        });
    } catch (error_1) {
        console.error(error_1);
        throw new Error("Internal server error");
    }
};

// Get single agreement by agreement ID
const getAgreementById = async (agreementId) => {
    try {
        return await new Promise(function (resolve, reject) {
            pool.query(
                `SELECT a.*, v.make, v.model, v.p_year, v.color,
                        c.c_name, c.embg, d.d_name
                 FROM agreement a
                 JOIN vehicle v ON a.vin = v.vin
                 JOIN client c ON a.embg = c.embg
                 JOIN dealership d ON a.tax_nr = d.tax_nr
                 WHERE a.a_id = $1`,
                [agreementId],
                (error, results) => {
                    if (error) {
                        reject(error);
                    }
                    if (results && results.rows && results.rows.length > 0) {
                        resolve(results.rows[0]);
                    } else {
                        resolve(null);
                    }
                }
            );
        });
    } catch (error_1) {
        console.error(error_1);
        throw new Error("Internal server error");
    }
};

// Get all agreements with payment status for a dealership
const getDealershipAgreementsWithPaymentStatus = async (taxNr) => {
    try {
        return await new Promise(function (resolve, reject) {
            pool.query(
                `SELECT a.*, v.make, v.model, v.p_year, v.color,
                        c.c_name, c.embg, d.d_name,
                        CASE WHEN p.p_id IS NOT NULL THEN true ELSE false END as payment_exists,
                        p.p_id, p.amount as payment_amount, p.bank, p.iban
                 FROM agreement a
                 JOIN vehicle v ON a.vin = v.vin
                 JOIN client c ON a.embg = c.embg
                 JOIN dealership d ON a.tax_nr = d.tax_nr
                 LEFT JOIN payment p ON a.a_id = p.a_id
                 WHERE a.tax_nr = $1
                 ORDER BY a.datum DESC`,
                [taxNr],
                (error, results) => {
                    if (error) {
                        reject(error);
                    }
                    if (results && results.rows) {
                        resolve(results.rows);
                    } else {
                        resolve([]);
                    }
                }
            );
        });
    } catch (error_1) {
        console.error(error_1);
        throw new Error("Internal server error");
    }
};

// Delete a vehicle
const deleteVehicle = async (vin, taxNr) => {
    try {
        return await new Promise(function (resolve, reject) {
            // First check if the vehicle belongs to the dealership and is not sold
            pool.query(
                `SELECT vin, status FROM vehicle WHERE vin = $1 AND tax_nr = $2`,
                [vin, taxNr],
                (error, results) => {
                    if (error) {
                        reject(error);
                        return;
                    }
                    
                    if (!results.rows || results.rows.length === 0) {
                        reject(new Error("Vehicle not found or you don't have permission to delete it"));
                        return;
                    }
                    
                    const vehicle = results.rows[0];
                    if (vehicle.status === false) {
                        reject(new Error("Cannot delete sold vehicles"));
                        return;
                    }
                    
                    // Delete the vehicle
                    pool.query(
                        `DELETE FROM vehicle WHERE vin = $1 AND tax_nr = $2`,
                        [vin, taxNr],
                        (deleteError, deleteResults) => {
                            if (deleteError) {
                                reject(deleteError);
                            } else {
                                resolve({ success: true, message: "Vehicle deleted successfully" });
                            }
                        }
                    );
                }
            );
        });
    } catch (error_1) {
        console.error(error_1);
        throw new Error("Internal server error");
    }
};

// Login dealership
const loginDealership = async (email, password) => {
    try {
        return await new Promise(function (resolve, reject) {
            pool.query(
                "SELECT * FROM dealership WHERE email = $1 AND pass = $2",
                [email, password],
                (error, results) => {
                    if (error) {
                        reject(error);
                    }
                    if (results && results.rows && results.rows.length > 0) {
                        resolve(results.rows[0]);
                    } else {
                        resolve(null);
                    }
                }
            );
        });
    } catch (error_1) {
        console.error(error_1);
        throw new Error("Internal server error");
    }
};

// Login client
const loginClient = async (email, password) => {
    try {
        return await new Promise(function (resolve, reject) {
            pool.query(
                "SELECT * FROM client WHERE email = $1 AND pass = $2",
                [email, password],
                (error, results) => {
                    if (error) {
                        reject(error);
                    }
                    if (results && results.rows && results.rows.length > 0) {
                        resolve(results.rows[0]);
                    } else {
                        resolve(null);
                    }
                }
            );
        });
    } catch (error_1) {
        console.error(error_1);
        throw new Error("Internal server error");
    }
};

// Create agreement
const createAgreement = async (body) => {
    return new Promise(function (resolve, reject) {
        const {
            A_Id,
            Price,
            Status,
            Datum,
            VIN,
            EMBG,
            Tax_Nr
        } = body;
        
        pool.query(
            "INSERT INTO agreement (A_Id, Price, Status, Datum, Tax_Nr, VIN, EMBG) VALUES ($1, $2, $3, $4, $5, $6, $7) RETURNING *",
            [A_Id, Price, Status, Datum, Tax_Nr, VIN, EMBG],
            (error, results) => {
                if (error) {
                    reject(new Error("Not able to create agreement."));
                }
                if (results && results.rows) {
                    // Update vehicle status to sold
                    pool.query(
                        "UPDATE vehicle SET status = false WHERE vin = $1",
                        [VIN],
                        (updateError, updateResults) => {
                            if (updateError) {
                                console.error("Error updating vehicle status:", updateError);
                            }
                        }
                    );
                    resolve(`Agreement created successfully.`);
                } else {
                    reject(new Error("Not able to create agreement."));
                }
            }
        );
    });
};

// Get client agreements
const getClientAgreements = async (embg) => {
    try {
        return await new Promise(function (resolve, reject) {
            pool.query(
                `SELECT a.*, v.make, v.model, v.p_year, v.color, v.price as vehicle_price, 
                        d.d_name as dealership_name,
                        CASE WHEN p.p_id IS NOT NULL THEN true ELSE false END as payment_exists
                 FROM agreement a 
                 JOIN vehicle v ON a.vin = v.vin 
                 JOIN dealership d ON a.tax_nr = d.tax_nr 
                 LEFT JOIN payment p ON a.a_id = p.a_id
                 WHERE a.embg = $1`,
                [embg],
                (error, results) => {
                    if (error) {
                        reject(error);
                    }
                    if (results && results.rows) {
                        resolve(results.rows);
                    } else {
                        reject(new Error("No results found"));
                    }
                }
            );
        });
    } catch (error_1) {
        console.error(error_1);
        throw new Error("Internal server error");
    }
};

// Create payment
const createPayment = async (body) => {
    return new Promise(function (resolve, reject) {
        const {
            Bank,
            IBAN,
            Amount,
            A_Id,
            EMBG
        } = body;
        
        pool.query(
            "INSERT INTO payment (Bank, IBAN, Amount, EMBG, A_Id) VALUES ($1, $2, $3, $4, $5) RETURNING *",
            [Bank, IBAN, Amount, EMBG, A_Id],
            (error, results) => {
                if (error) {
                    reject(new Error("Not able to create payment."));
                }
                if (results && results.rows) {
                    resolve(`Payment created successfully.`);
                } else {
                    reject(new Error("Not able to create payment."));
                }
            }
        );
    });
};

// Check if agreement has payment
const checkAgreementPayment = async (aId) => {
    try {
        return await new Promise(function (resolve, reject) {
            pool.query(
                "SELECT * FROM payment WHERE a_id = $1",
                [aId],
                (error, results) => {
                    if (error) {
                        reject(error);
                    }
                    if (results && results.rows && results.rows.length > 0) {
                        resolve(true);
                    } else {
                        resolve(false);
                    }
                }
            );
        });
    } catch (error_1) {
        console.error(error_1);
        throw new Error("Internal server error");
    }
};

// Get payment details for an agreement
const getPaymentDetails = async (aId) => {
    try {
        return await new Promise(function (resolve, reject) {
            pool.query(
                `SELECT p.*, a.price as agreement_price, a.datum as agreement_date,
                        v.vin, v.make, v.model, v.p_year, v.color,
                        d.d_name as dealership_name,
                        c.c_name as client_name
                 FROM payment p
                 JOIN agreement a ON p.a_id = a.a_id
                 JOIN vehicle v ON a.vin = v.vin
                 JOIN dealership d ON a.tax_nr = d.tax_nr
                 JOIN client c ON a.embg = c.embg
                 WHERE p.a_id = $1`,
                [aId],
                (error, results) => {
                    if (error) {
                        reject(error);
                    }
                    if (results && results.rows && results.rows.length > 0) {
                        resolve(results.rows[0]);
                    } else {
                        resolve(null);
                    }
                }
            );
        });
    } catch (error_1) {
        console.error(error_1);
        throw new Error("Internal server error");
    }
};

// Get payment details by VIN
const getPaymentDetailsByVin = async (vin) => {
    try {
        return await new Promise(function (resolve, reject) {
            pool.query(
                `SELECT p.*, a.price as agreement_price, a.datum as agreement_date,
                        v.vin, v.make, v.model, v.p_year, v.color,
                        d.d_name as dealership_name,
                        c.c_name as client_name
                 FROM payment p
                 JOIN agreement a ON p.a_id = a.a_id
                 JOIN vehicle v ON a.vin = v.vin
                 JOIN dealership d ON a.tax_nr = d.tax_nr
                 JOIN client c ON a.embg = c.embg
                 WHERE v.vin = $1`,
                [vin],
                (error, results) => {
                    if (error) {
                        reject(error);
                    }
                    if (results && results.rows && results.rows.length > 0) {
                        resolve(results.rows[0]);
                    } else {
                        resolve(null);
                    }
                }
            );
        });
    } catch (error_1) {
        console.error(error_1);
        throw new Error("Internal server error");
    }
};

// Get payments for a dealership (all payments for their agreements)
const getDealershipPayments = async (taxNr) => {
    try {
        return await new Promise(function (resolve, reject) {
            pool.query(
                `SELECT p.*, a.price as agreement_price, a.datum as agreement_date,
                        v.make, v.model, v.p_year, v.color,
                        c.c_name as client_name, c.embg as client_embg
                 FROM payment p
                 JOIN agreement a ON p.a_id = a.a_id
                 JOIN vehicle v ON a.vin = v.vin
                 JOIN client c ON a.embg = c.embg
                 WHERE a.tax_nr = $1
                 ORDER BY p.p_id DESC`,
                [taxNr],
                (error, results) => {
                    if (error) {
                        reject(error);
                    }
                    if (results && results.rows) {
                        resolve(results.rows);
                    } else {
                        reject(new Error("No results found"));
                    }
                }
            );
        });
    } catch (error_1) {
        console.error(error_1);
        throw new Error("Internal server error");
    }
};

// Get all agreements for a dealership
const getDealershipAgreements = async (taxNr) => {
    try {
        return await new Promise(function (resolve, reject) {
            pool.query(
                `SELECT a.*, v.make, v.model, v.p_year, v.color,
                        c.c_name, c.embg, d.d_name
                 FROM agreement a
                 JOIN vehicle v ON a.vin = v.vin
                 JOIN client c ON a.embg = c.embg
                 JOIN dealership d ON a.tax_nr = d.tax_nr
                 WHERE a.tax_nr = $1
                 ORDER BY a.datum DESC`,
                [taxNr],
                (error, results) => {
                    if (error) {
                        reject(error);
                    }
                    if (results && results.rows) {
                        resolve(results.rows);
                    } else {
                        reject(new Error("No results found"));
                    }
                }
            );
        });
    } catch (error_1) {
        console.error(error_1);
        throw new Error("Internal server error");
    }
};

// Get all dealerships (for debugging)
const getAllDealerships = async () => {
    try {
        return await new Promise(function (resolve, reject) {
            pool.query(
                "SELECT tax_nr, d_name, email, pass FROM dealership",
                (error, results) => {
                    if (error) {
                        reject(error);
                    }
                    if (results && results.rows) {
                        resolve(results.rows);
                    } else {
                        reject(new Error("No results found"));
                    }
                }
            );
        });
    } catch (error_1) {
        console.error(error_1);
        throw new Error("Internal server error");
    }
};

module.exports = {
    getVehicles,
    getMyVehicles,
    createVehicle,
    deleteVehicle,
    registerUser,
    registerDealership,
    getAgreement,
    getAgreementById,
    getDealershipAgreementsWithPaymentStatus,
    loginDealership,
    loginClient,
    createAgreement,
    getClientAgreements,
    createPayment,
    checkAgreementPayment,
    getPaymentDetails,
    getPaymentDetailsByVin,
    getDealershipPayments,
    getDealershipAgreements,
    getAllDealerships,
};
