import "./App.css";
import { BrowserRouter, Routes, Route } from "react-router-dom";
import Layout from "./pages/Layout";
import Home from "./pages/Home";
import MyList from "./pages/MyList";
import AddVehicle from "./pages/AddVehicle";
import Agreement from "./pages/Agreement";
import Agreements from "./pages/Agreements";
import RegisterForm from "./pages/RegisterForm";
import DealershipLogin from "./pages/DealershipLogin";
import ClientLogin from "./pages/ClientLogin";
import Login from "./pages/Login";
import CreateAgreement from "./pages/CreateAgreement";
import MyAgreements from "./pages/MyAgreements";
import CreatePayment from "./pages/CreatePayment";
import PaymentDetails from "./pages/PaymentDetails";
import DealershipPayments from "./pages/DealershipPayments";
import DealershipRegisterForm from "./pages/DealershipRegisterForm";
import RegisterSelection from "./pages/RegisterSelection";
import Documents from "./pages/Documents";
import Reports from "./pages/Reports";
import { Flex } from "@chakra-ui/react";

function App() {
    return (
        <Flex direction='column'>
            <BrowserRouter>
                <Routes>
                    <Route exact path='/' element={<Layout />}>
                        <Route index element={<Home />} />
                        <Route path='mylist' element={<MyList />} />
                        <Route path='addvehicle' element={<AddVehicle />} />
                        <Route path='registerform' element={<RegisterForm />} />
                        <Route path='agreement' element={<Agreement />} />
                        <Route path='dealershiplogin' element={<DealershipLogin />} />
                        <Route path='clientlogin' element={<ClientLogin />} />
                        <Route path='login' element={<Login />} />
                        <Route path='register' element={<RegisterSelection />} />
                        <Route path='dealershipregister' element={<DealershipRegisterForm />} />
                        <Route path='createagreement' element={<CreateAgreement />} />
                        <Route path='myagreements' element={<MyAgreements />} />
                        <Route path='createpayment' element={<CreatePayment />} />
                        <Route path='paymentdetails' element={<PaymentDetails />} />
                        <Route path='dealershippayments' element={<DealershipPayments />} />
                        <Route path='documents' element={<Documents />} />
                        <Route path='reports' element={<Reports />} />
                    </Route>
                </Routes>
            </BrowserRouter>
        </Flex>
    );
}

export default App;
