import { Flex, Text, Button, VStack, HStack, Box, useToast } from "@chakra-ui/react";
import { useNavigate } from "react-router-dom";

const RegisterSelection = () => {
    const navigate = useNavigate();
    const toast = useToast();

    const handleClientRegister = () => {
        navigate("/registerform");
    };

    const handleDealershipRegister = () => {
        navigate("/dealershipregister");
    };

    return (
        <Flex width='100%' flexDir='column' justifyContent='center' maxWidth='600px'>
            <Text
                marginBottom='20px'
                textAlign='center'
                fontWeight='bold'
                fontSize='30px'
                justifySelf='center'>
                Register Account
            </Text>
            
            <Box
                borderWidth="1px"
                borderRadius="lg"
                overflow="hidden"
                p="8"
                bg="white"
                boxShadow="lg">
                
                <VStack spacing={6} align="center">
                    <Text fontSize="lg" color="gray.600" textAlign="center">
                        Choose the type of account you want to create:
                    </Text>
                    
                    <HStack spacing={8} align="stretch">
                        <VStack spacing={4} align="center" minW="200px">
                            <Box
                                borderWidth="2px"
                                borderRadius="lg"
                                p="6"
                                bg="blue.50"
                                borderColor="blue.200"
                                textAlign="center"
                                minH="200px"
                                display="flex"
                                flexDir="column"
                                justifyContent="space-between">
                                
                                <VStack spacing={3}>
                                    <Text fontSize="xl" fontWeight="bold" color="blue.700">
                                        Client Account
                                    </Text>
                                    <Text fontSize="sm" color="gray.600" textAlign="center">
                                        Register as a client to browse vehicles, create agreements, and make payments.
                                    </Text>
                                </VStack>
                                
                                <Button
                                    colorScheme="blue"
                                    size="lg"
                                    onClick={handleClientRegister}
                                    width="100%">
                                    Register as Client
                                </Button>
                            </Box>
                        </VStack>
                        
                        <VStack spacing={4} align="center" minW="200px">
                            <Box
                                borderWidth="2px"
                                borderRadius="lg"
                                p="6"
                                bg="green.50"
                                borderColor="green.200"
                                textAlign="center"
                                minH="200px"
                                display="flex"
                                flexDir="column"
                                justifyContent="space-between">
                                
                                <VStack spacing={3}>
                                    <Text fontSize="xl" fontWeight="bold" color="green.700">
                                        Dealership Account
                                    </Text>
                                    <Text fontSize="sm" color="gray.600" textAlign="center">
                                        Register as a dealership to list vehicles, create agreements, and manage sales.
                                    </Text>
                                </VStack>
                                
                                <Button
                                    colorScheme="green"
                                    size="lg"
                                    onClick={handleDealershipRegister}
                                    width="100%">
                                    Register as Dealership
                                </Button>
                            </Box>
                        </VStack>
                    </HStack>
                    
                    <Text fontSize="sm" color="gray.500" textAlign="center" mt="4">
                        Already have an account? <Button variant="link" colorScheme="blue" onClick={() => navigate("/login")}>Sign in here</Button>
                    </Text>
                </VStack>
            </Box>
        </Flex>
    );
};

export default RegisterSelection;
