drop schema if exists triger cascade;
create schema triger;

drop table if exists dealership cascade;
drop table if exists vehicle cascade;
drop table if exists client cascade;
drop table if exists agreement cascade;
drop table if exists payment cascade;

CREATE TABLE dealership (
    Tax_Nr varchar(50) primary key,
    D_Name varchar(50) not null,
    Brands varchar(200)[] not null,
    Email varchar(50) not null,
    Pass varchar(50) not null,
    Director varchar(50),
    Telephones varchar(200)[] not null,
    Addres varchar(100) not null
);

CREATE TYPE body_type AS ENUM ('Motorcycle', 'Car', 'Truck', 'Van');
CREATE TYPE color_type AS ENUM ('black', 'white', 'red', 'blue', 'green', 'yellow', 'orange', 'purple', 'silver', 'grey', 'cyan', 'magenta');

CREATE TABLE vehicle (
	VIN varchar(30) primary key,
    Body body_type not null,
    Make varchar(50) not null,
    Model varchar(50) not null,
    P_Year integer not null,
    Capacity varchar(100) not null,
 	Power integer not null,
    Color color_type,
    Price integer not null,
    Status boolean not null,
    Tax_Nr varchar(50) not null,
    constraint fk_dealership foreign key (Tax_Nr) references dealership(Tax_Nr)
);

CREATE TABLE client (
    EMBG varchar(50) primary key,
    C_Name varchar(50) not null,
    Email varchar(50) not null,
    Pass varchar(50) not null,
    Telephone varchar(50)
);

CREATE TABLE agreement (
    A_Id varchar(100) primary key,
    Price Integer not null,
    Status boolean not null,
    Datum date not null,
    Tax_Nr varchar(50) not null,
    VIN varchar(50) not null,
    EMBG varchar(50) not null,
    constraint fk_Dealership foreign key (Tax_Nr) references dealership(Tax_Nr),
    constraint fk_Vehicle foreign key (VIN) references vehicle(VIN),
    constraint fk_Client foreign key (EMBG) references client(EMBG)
);

CREATE TABLE payment (
    P_Id serial primary key,
    Bank varchar(50) not null,
    IBAN varchar(100) not null,
    Amount integer not null,
    EMBG varchar(50) not null,
    A_Id varchar(100) not null,
    constraint fk_Agreement foreign key (A_Id) references agreement(A_Id),
    constraint fk_Client foreign key (EMBG) references client(EMBG)
);