package com.example.cimeri.web.controller;

import com.example.cimeri.repository.ApartmentRepository;
import com.example.cimeri.repository.CityRepository;
import jakarta.servlet.http.HttpSession;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.io.IOException;
import java.util.List;

@Controller
@RequestMapping({"/listneededapartments"})
public class ListApartmentsController {


    private final ApartmentRepository apartmentRepository;
    private final CityRepository cityRepository;

    public ListApartmentsController(ApartmentRepository apartmentRepository, CityRepository cityRepository) {
        this.apartmentRepository = apartmentRepository;
        this.cityRepository = cityRepository;
    }

    @GetMapping
    public String getPage(Model model,HttpSession httpSession) throws IOException {


        String cityname= (String) httpSession.getAttribute("cityname");
        int number_of_roommates= (int) httpSession.getAttribute("number_of_roommates");
        int budget= (int) httpSession.getAttribute("budget");
        Long cityid= (Long) httpSession.getAttribute("cityid");


        httpSession.removeAttribute("cityname");
        httpSession.removeAttribute("number_of_roommates");
        httpSession.removeAttribute("budget");
        httpSession.removeAttribute("cityid");

        List filteredapartments=apartmentRepository.filteredapartments(cityid,number_of_roommates,budget);
        model.addAttribute("filteredapartments",filteredapartments);

        return "listneededapartments";
    }

    @PostMapping
    public String listneededapartments(@RequestParam int number_of_roommates, @RequestParam Long cityid, @RequestParam int budget
            , HttpSession httpSession, Model model)
    {

        String cityname= cityRepository.findCityByCityId(cityid);
        httpSession.setAttribute("number_of_roommates",number_of_roommates);
        httpSession.setAttribute("cityname",cityname);
        httpSession.setAttribute("cityid",cityid);
        httpSession.setAttribute("budget",budget);

        return "redirect:/listneededapartments";

    }

}

