package com.example.cimeri.repository;

import com.example.cimeri.model.Apartment;
import com.example.cimeri.model.Building;
import com.example.cimeri.model.Faculty;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;

@Repository
public interface ApartmentRepository extends JpaRepository<Apartment,Long> {


    @Query("select Max(apartmentid) from Apartment")
    Long findMaxApartmentID();


    @Query("select u.ime,u.prezime,u.phone_number,u.email_address,a.apartmentsize,a.apartmentfloorandroomnumber,b.buildingaddress,p.price,photos.photosurl from Building b,User u, Apartment a,Post p,OwnerPost op, Owner o, Photos photos WHERE u.userid=a.ownerid and op.ownerpostid=p.postid and op.ownerid=u.userid and o.ownerid=u.userid and o.ownerid=a.ownerid and b.buildingid=a.buildingid and a.apartmentid=op.apartmentid and photos.postid=p.postid and photos.postid=op.ownerpostid and p.numberofroommates=:number_of_roommates and p.price<=:budget and p.cityid=:cityid")
    List filteredapartments(@Param("cityid")Long cityid, @Param("number_of_roommates") int number_of_roommates, @Param("budget") int budget);

    @Query("select u.ime,u.prezime,u.phone_number,u.email_address,a.apartmentsize,a.apartmentfloorandroomnumber,b.buildingaddress,p.price,photos.photosurl from Building b,User u, Apartment a,Post p,OwnerPost op, Owner o, Photos photos WHERE u.userid=a.ownerid and op.ownerpostid=p.postid and op.ownerid=u.userid and o.ownerid=u.userid and o.ownerid=a.ownerid and b.buildingid=a.buildingid and a.apartmentid=op.apartmentid and photos.postid=p.postid and photos.postid=op.ownerpostid")
    List allapartments();
}
