-- Inserting data into city table
INSERT INTO city (CityName)
VALUES ('Skopje'),
       ('Veles'),
       ('Ohrid'),
       ('Kumanovo'),
       ('Stip');

-- Inserting data into faculty table
INSERT INTO faculty (FacultyName, CityID)
VALUES ('FINKI', 1),
       ('PMF', 1),
       ('Gastronomija', 8);

-- Inserting data into building table
INSERT INTO building (CityID, BuildingAddress)
VALUES (1, 'Blaze Koneski 10'),
       (1, 'Gologanov 24'),
       (8, 'Rade Koncar 1'),
       (7, 'Gologanov 3'),
       (12, 'Kiro Gligorov 3');

-- Inserting data into appuser table
INSERT INTO appuser (prezime, ime, Password, phone_number , email_address , username)
VALUES ('Trajkovski', 'Filip', 'ft12', '111-111-111', 'test@mail.com', 'usernamet'),
       ('Nikolovski', 'Blagoja', 'bn12', '111-111-111', 'test@mail.com', 'usernamen'),
       ('Nikolov', 'Darko', 'dn23', '123-234-444', 'test@mail.com', 'usernamenn'),
       ('Aleksandrov', 'Aleksandar', 'aa23', '222-222-222', 'test@mail.com','usernamea'),
       ('Ristova', 'Ana', 'ar23', '444-222-111', 'test@mail.com','usernamer');

-- Inserting data into apartment_owner table
INSERT INTO apartment_owner (OwnerID)
VALUES (1),
       (3),
       (4);

-- Inserting data into administrator table
INSERT INTO administrator (AdminID, AdminRole)
VALUES (4, 'mod'),
       (5, 'mod'),
       (6, 'mod');

-- Inserting data into student table
INSERT INTO student (StudentID, FacultyID, Age, Gender)
VALUES (3, 1, 21, 'male'),
       (2, 1, 21, 'male');

-- Inserting data into apartment table
INSERT INTO apartment (BuildingID, OwnerID, ApartmentFloorAndRoomNumber, ApartmentSize)
VALUES (1, 1, 'Vlez 4 Stan 3', '60m2'),
       (2, 2, 'Vlez 1 Stan 12', '55m2'),
       (3, 3, 'Vlez 3 Stan 6', '70m2');

-- Inserting data into apartment_agreement table
INSERT INTO apartment_agreement (ApartmentID, OwnerID, DateSigned, DateExpires, ApartmentRent)
VALUES (4, 1, TO_DATE('10/09/2022', 'DD/MM/YYYY'), TO_DATE('30/06/2023', 'DD/MM/YYYY'), 250),
       (5, 2, TO_DATE('10/09/2022', 'DD/MM/YYYY'), TO_DATE('30/06/2023', 'DD/MM/YYYY'), 300),
       (4, 3, TO_DATE('10/09/2022', 'DD/MM/YYYY'), TO_DATE('30/06/2023', 'DD/MM/YYYY'), 250);

-- Inserting data into student_signs table
INSERT INTO student_signs (StudentID, AgreementID)
VALUES (2, 3),
       (1, 3);

-- Inserting data into post table
INSERT INTO post (CityID, NumberOfRoommates, Price, DatePosted, Description)
VALUES ((SELECT CityID FROM city WHERE CityName = 'Skopje'), 2, 250, TO_DATE('10/09/2022', 'DD/MM/YYYY'), 'baram cimer'),
       ((SELECT CityID FROM city WHERE CityName = 'Skopje'), 2, 300, TO_DATE('10/09/2022', 'DD/MM/YYYY'), 'izdavam stan'),
       ((SELECT CityID FROM city WHERE CityName = 'Skopje'), 2, 300, TO_DATE('10/09/2022', 'DD/MM/YYYY'), 'izdavam stan'),
       ((SELECT CityID FROM city WHERE CityName = 'Skopje'), 2, 300, TO_DATE('10/09/2022', 'DD/MM/YYYY'), 'baram cimer');

-- Inserting data into owner_post table
INSERT INTO owner_post (OwnerPostID, ApartmentID, OwnerID)
VALUES (2, 3, 1),
       (3, 2, 2),
       (6, 4, 3);

-- Inserting data into apartment_photos table
INSERT INTO apartment_photos (PostID, PhotosURL)
VALUES (2, 'link1'),
       (3, 'link3'),
       (6, 'link4');

-- Inserting data into student_post table
INSERT INTO student_post (StudentPostID, StudentID)
VALUES (1, 1),
       (4, 2),
       (5, 2);

-- Inserting data into moderates_posts_for table
INSERT INTO moderates_posts_for (CityID, AdminID)
VALUES ((SELECT CityID FROM city WHERE CityName = 'Skopje'), 4),
       ((SELECT CityID FROM city WHERE CityName = 'Skopje'), 5),
       ((SELECT CityID FROM city WHERE CityName = 'Stip'), 6);
