insert into sector_of_interal_affairs(s_id, city) values
(1, 'Скопје'),
(2, 'Тетово'),
(3, 'Куманово'),
(4, 'Охрид'),
(5, 'Битола'),
(6, 'Струмица'),
(7, 'Кавадарци'),
(8, 'Штип'),
(9, 'Прилеп'),
(10, 'Гостивар'),
(11, 'Гевгелија'),
(12, 'Радовиш'),
(13, 'Ресен'),
(14, 'Кочани'),
(15, 'Кичево');

-- M for Male and F for Female
-- Наместо број на регион во ембг за странци се става 04
insert into people(pe_id, first_name, last_name, gender, address, picture, contact, embg, date_of_birth, country, nationality) values
(1, 'Кице', 'Петров', 'M', 'ул. 144 бр. 20', 'https://images.unsplash.com/photo-1615109398623-88346a601842?q=80&w=1000&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxzZWFyY2h8MTZ8fG1hbnxlbnwwfHwwfHx8MA%3D%3D', '077-777-766', '1002995470090', '1995-02-10', 'Македонија', 'Македонец'),
(2, 'Митре', 'Пандиловски', 'М', 'ул. Широк Сокак бр. 10', 'https://img.freepik.com/premium-photo/photo-document-passport-id-mature-caucasian-man-suit_262388-3596.jpg?w=360', '070-223-305', '1004991410092', '1991-04-10', 'Македонија', 'Македонец'),
(3, 'Елена', 'Стојановска', 'F', 'ул. Маршал Тито бр. 25', 'https://img.freepik.com/free-photo/portrait-young-beautiful-woman-with-smoky-eyes-makeup-pretty-young-adult-girl-posing-studio-closeup-attractive-female-face_186202-4439.jpg?size=626&ext=jpg&ga=GA1.1.938941469.1701200455&semt=ais', '070-234-567', '2912000435168', '2000-12-29', 'Македонија', 'Македонец'),
(4, 'Стојна', 'Кириловска', 'F', 'бул. Гоце Делчев бр. 7', 'https://img.freepik.com/free-photo/beautiful-blonde-woman-portrait-smiling-face_53876-137593.jpg?size=626&ext=jpg&ga=GA1.1.938941469.1701200455&semt=ais', '072-456-789', '0509002447053', '2002-09-05', 'Македонија', 'Македонец'),
(5, 'Надица', 'Станоевска', 'F', 'бул. Митрополит Теодосиј Гологанов бр. 30', 'https://img.freepik.com/free-photo/portrait-young-woman-wearing-striped-blouse_273609-19535.jpg?size=626&ext=jpg&ga=GA1.1.938941469.1701200455&semt=ais', '076-678-901', '1706985455136', '1985-06-17', 'Македонија', 'Македонец'),
(6, 'Огнен', 'Димовски', 'M', 'ул. Македонска бр. 18', 'https://img.freepik.com/premium-photo/portrait-face-headshot-man-studio-isolated-white-background-posing-with-casual-attitude-handsome-young-guy-serious-male-person-pose-id-photo-passport-picture-confidence_590464-174264.jpg?w=2000', '075-567-890', '2307998490128', '1998-07-23', 'Македонија', 'Македонец'),
(7, 'Драган', 'Бучков', 'M', 'бул. Климент Охридски бр. 42', 'https://img.freepik.com/free-photo/emotions-people-concept-headshot-serious-looking-handsome-man-with-beard-looking-confident-determined_1258-26730.jpg?size=626&ext=jpg&ga=GA1.1.938941469.1701200455&semt=ais', '077-789-012', '1010963450183', '1963-10-10', 'Македонија', 'Македонец'),
(8, 'Марија', 'Петков', 'F', 'ул. Даме Груев бр. 11', 'https://img.freepik.com/free-photo/beautiful-female-looking-into-camera-with-dreamy-expression_273609-12390.jpg?size=626&ext=jpg&ga=GA1.1.938941469.1701200455&semt=ais', '078-890-123', '2511979435026', '1979-11-25', 'Македонија', 'Македонец'),
(9, 'Стефанија', 'Петкова', 'F', 'ул. Јосиф Јосифовски Свештарот бр. 14', 'https://img.freepik.com/free-photo/pretty-smiling-joyfully-female-with-fair-hair-dressed-casually-looking-with-satisfaction_176420-15187.jpg?size=626&ext=jpg&ga=GA1.1.938941469.1701200455&semt=ais', '079-901-234', '2902002465155', '2002-02-28', 'Македонија', 'Македонец'),
(10, 'Теодора', 'Кочовска', 'F', 'ул. Дебарца бр. 22', 'https://img.freepik.com/free-photo/portrait-young-tender-redhead-teenage-girl-with-green-eyes-wearing-blue-top-looking-with-serious-pensive-expression-standing-blue-wall-her-lips-slightly-parted_344912-1067.jpg?size=626&ext=jpg&ga=GA1.1.938941469.1701200455&semt=ais', '075-112-233', '2408948445017', '1948-08-24', 'Македонија', 'Македонец'),
(11, 'Анастас', 'Ангелески', 'M', 'бул. 11-ти Октомври бр.64', 'https://img.freepik.com/free-photo/close-up-bearded-tired-man_176420-18785.jpg?size=626&ext=jpg&ga=GA1.1.938941469.1701200455&semt=ais', '076-223-344', '310598450069', '1984-05-31', 'Македонија', 'Македонец'),
(12, 'Жана', 'Апостолова', 'F', 'бул. Туристичка бр. 65', 'https://img.freepik.com/free-photo/portrait-beautiful-redhead-woman-smiling_176420-8008.jpg?size=626&ext=jpg&ga=GA1.1.938941469.1701200455&semt=ais', '070-123-456', '0701972435058', '1972-01-07', 'Македонија', 'Македонец'),
(13, 'Иван', 'Петрушев', 'M', 'ул. Даме Груев бр. 92', 'https://img.freepik.com/free-photo/worldface-british-guy-white-background_53876-146315.jpg?size=626&ext=jpg&ga=GA1.1.938941469.1701200455&semt=ais', '077-654-321', '2004989430139', '1989-04-20', 'Македонија', 'Македонец'),
(14, 'Марио', 'Трајковски', 'M', 'ул. Батаљон Стив Наумов бр. 15', 'https://img.freepik.com/free-photo/young-bearded-man-with-white-t-shirt_273609-7187.jpg?size=626&ext=jpg&ga=GA1.1.938941469.1701200455&semt=ais', '078-321-456', '2103965410071', '1965-03-21', 'Македонија', 'Македонец'),
(15, 'Миомир', 'Трајков', 'M', 'ул. 29-ти Ноември бр. 70', 'https://img.freepik.com/free-photo/close-up-shot-serious-looking-handsome-adult-european-man-with-red-hair-beard-staring-with-focused-determined-expression-standing-strict-pose-gray-wall_176420-27574.jpg?size=626&ext=jpg&ga=GA1.1.938941469.1701200455&semt=ais', '074-123-654', '1210978470198', '1978-10-12', 'Македонија', 'Македонец'),
(16, 'Мирка', 'Башарова', 'F', 'ул. Антон Димитров бр. 123', 'https://img.freepik.com/free-photo/beautiful-blonde-woman-portrait-smiling-face_53876-139732.jpg?size=626&ext=jpg&ga=GA1.1.938941469.1701200455&semt=ais', '072-456-321', '1112988455087', '1988-12-11', 'Македонија', 'Македонец'),
(17, 'Христина', 'Стојкоска', 'F', 'ул. Борче Кочовски бр. 91', 'https://img.freepik.com/free-photo/headshot-attractive-red-haired-european-woman-with-freckled-skin-looks-seriously-camera-has-minimal-make-up-wears-red-sweater-isolated-white-natural-beauty-concept_176532-8382.jpg?size=626&ext=jpg&ga=GA1.1.938941469.1701200455&semt=ais', '071-654-123', '0101993475135', '1993-01-01', 'Македонија', 'Македонец'),
(18, 'Цветан', 'Нечев', 'M', 'ул. Солидарност бр. 31', 'https://img.freepik.com/free-photo/cropped-portrait-young-handsome-boy-looking-camera-posing-isolated-green-background_155003-45249.jpg?size=626&ext=jpg&ga=GA1.1.938941469.1701200455&semt=ais', '070-564-789', '3011995490133', '1996-11-30', 'Македонија', 'Македонец'),
(19, 'Инес', 'Шулајковска', 'F', 'ул. Цар Самоил бр.25', 'https://img.freepik.com/free-photo/portrait-young-beautiful-smiling-hipster-girl-trendy-summer-checkered-shirt-jeans-clothes_158538-3329.jpg?size=626&ext=jpg&ga=GA1.1.938941469.1701200455&semt=ais', '075-945-357', '2902004415004', '2004-02-29', 'Македонија', 'Македонец'),
(20, 'Филипа', 'Кралевска', 'M', 'бул. Партизански Одреди бр. 147', 'https://img.freepik.com/free-photo/people-emotions-close-up-confident-smiling-young-woman-looking-camera-standing-casual-r_1258-87448.jpg?size=626&ext=jpg&ga=GA1.1.938941469.1701200455&semt=ais', '076-943-757', '1003000455187', '2000-03-10', 'Македонија', 'Македонец'),
(21, 'Ангела', 'Меркел', 'F', 'бул. Партизански Одреди бр. 29', 'https://img.freepik.com/free-photo/portrait-young-pretty-cheerful-girl-smiling_176420-9553.jpg?size=626&ext=jpg&ga=GA1.1.938941469.1701200455&semt=ais', '078-137-796', '1307001045020', '2001-07-13', 'Германија', 'Германка'),
(22, 'Фатих', 'Јилмаз', 'M', 'ул. Митрополит Теодосиј Гологанов бр. 55', 'https://images.unsplash.com/photo-1615109398623-88346a601842?q=80&w=1000&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxzZWFyY2h8MTZ8fG1hbnxlbnwwfHwwfHx8MA%3D%3D', '074-852-654', '1709002040061', '2002-09-17', 'Турција', 'Турчин'),
(23, 'Филипе Алаин', 'Лаурент', 'M', 'бул. 8-ми Септември бр. 8', 'https://images.unsplash.com/photo-1615109398623-88346a601842?q=80&w=1000&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxzZWFyY2h8MTZ8fG1hbnxlbnwwfHwwfHx8MA%3D%3D', '075-641-965', '1303977040147', '1977-03-13', 'Франција', 'Французинка'),
(24, 'Аиша', 'Саад', 'F', 'бул. Туристичка бр. 100', 'https://img.freepik.com/free-photo/portrait-young-pretty-cheerful-girl-smiling_176420-9553.jpg?size=626&ext=jpg&ga=GA1.1.938941469.1701200455&semt=ais', '076-623-645', '1612948045078', '1948-12-15', 'Сирија', 'Сиријка'),
(25, 'Мандла', 'Дламини', 'F', 'бул. 3-та Македонска Ударна Бригада бр. 52', 'https://img.freepik.com/free-photo/portrait-expressive-young-woman_1258-48167.jpg?size=626&ext=jpg&ga=GA1.1.938941469.1701200455&semt=ais', '070-506-907', '1802002045163', '2002-02-18', 'Јужноафриканска Република', 'Јужноафриканка');

insert into accused(pe_id) values
(1),
(5),
(11),
(22);

insert into witness(pe_id) values
(3),
(13),
(16),
(23);

insert into victim(pe_id) values
(2),
(9),
(10),
(24);

insert into officer(pe_id, o_date_of_employment,o_badge_no, o_password) values
(13, '2020-05-01',222223 ,'o1_123'),
(14, '2023-02-01', 222224,'o2_123'),
(15, '2019-12-01',222225 ,'o3_123'),
(16, '2011-12-01', 222226,'o4_123');

insert into police_station (p_id, p_address, s_id, pe_id) values
(1, 'ул. Иван Аговски бр. 3', 1, 13),
(2, 'ул. Маршал Тити бб', 2, 14),
(3, 'ул. 29-ти Ноември бб', 13, 15),
(4, 'бул. Mакедонски просветители бр. 21', 4, 16);

insert into policeman(pe_id, badge_no, p_date_of_employment, rank, p_id, p_password) values
(4, 122323, '2018-10-10', 5, 1, 'p1_123'),
(6, 122324, '2019-10-10', 3, 1, 'p2_123'),
(7, 122325, '2015-10-10', 2, 2, 'p3_123'),
(8, 122326, '2016-10-10', 1, 2, 'p4_123'),
(12, 122328, '2010-10-10', 1, 2, 'p5_123'),
(19, 126323, '2013-10-10', 1, 3, 'p6_123'),
(17, 434343, '2016-10-10', 2, 4, 'p7_123'),
(18, 666666, '2023-10-10', 5, 4, 'p8_123'),
(25, 777777, '2023-10-10', 5, 4, 'p8_123');

-- status: Активен A, Затворен Z
insert into crime_case(c_id, c_name, opening_date, c_status, p_id) values
(1, 'Подморница', '2023-11-27', 'A', 1),
(2, 'Хакери', '2011-03-03', 'Z', 3),
(3, 'Тероризам', '2016-02-01', 'Z', 2),
(4, 'Насилство', '2017-10-23', 'Z', 4),
(5, 'Тревник', '2023-10-27', 'A', 3),
(6, 'Киднапирање', '2022-08-27', 'A', 4);

-- case_id, policemen_id, victim_id, witness_id
insert into statements (s_id, statement_date, description, incident_timestamp, incident_place, c_id, pe_id, victim_pe_id, witness_pe_id) values
(1, '2016-05-11', 'Влегол во автобус. Непознато лице му извадило нож...', '2016-04-22 19:10:25', 'ул. Рузвелтова во градски автобус бр.4', 3, 17, 2, 3),
(2, '2017-10-23', 'Насилство во семејна куќа...', '2017-10-23 09:05:40', 'ул. Дебарца бр. 107', 4, 6, 9, 13),
(3, '2022-08-27', 'Државјанин на Република Косово го нападна министерот за здраство со боксирач...', '2022-08-28 23:40:00', 'ул. Орце Николов бр. 56', 6, 18, 10, 16),
(4, '2011-03-03', 'Хакерски напад врз компјутер на лице од влада...', '2011-03-03 03:58:45', 'бул. Туристичка бр. 137', 2, 8, 24, 23),
(5, '2024-08-27', 'Одбраната на околу 20-тина обвинети денеска даваше воведни зборови и случајот почнува од нула.
 Ова судење се врати на почеток поради пензионирање на поротник, а судот немаше делегирано резервни поротници
 во овој најголем судски предмет од организиран криминал.Застапник на обвинението и натаму е Лиле Стефанова, обвинителка за
организиран криминал и корупција. Во претходните четири години, се слушнаа илјадници прислушувани разговори одделно за сите
кривини дела што им се товарат на 20-мината обвинети и ќе се слушаат најверојатно повторно. Повторно ќе се изведува и целата
доказна постапка и ќе се викаат десетици и десетици сведоци.', '2023-12-28 13:40:00', 'ул. Партизански Одреди бр. 63', 1, 7, 9, 16),
(6, '2021-07-27', '„Тревник“– Истрагата, со работен наслов „Tревник“, која ја отвора СЈО, како резултат на прислушувани и видео снимки, јавно необјавени разговори,
опфаќа основано сомнение за кривичноправни дејствија на три лица за изградба на три викенд-куќи во Општина Зелениково, без да имаат право на таква зграда,
односно градење без одобрение за градење. Според прибавените докази, меѓу кои и сателитски снимки, нивно вештачење, како и друга документација,
овие три викенд-куќи биле започнати да се градат во 2011 година, а одобрение за градење од општината е добиено во 2013 година, кога веќе биле и завршени.
 Законот за градење предвидува обратен редослед, односно најпрвин правосилно одобрение за градење, па отпочнување со градење, а надвор од тој редослед таквите
противзаконски дејствија се предвидени и казниви со соодветното кривично дело, бесправно градење од член 244 а став 1 од КЗ, за кое е и отворена оваа истрага.',
'2021-12-28 13:40:00', 'ул. Партизански Одреди бр. 62', 5,6, 10, 13),
(7, '2021-07-27', 'Според судот, обвинетите започнале со градба на спорните згради , но подоцна побарале дозволи, па
нивните куќи биле легализирани според законската процедура за легализација на бесправно изградени објекти. Според судот,
 исто така, од суштествено значење е што претходно никоја од институциите не утврдила дека се работи за дивоградби.',
'2021-12-28 13:40:00', 'ул. Петар Поп Арсов бр.12', 5,6, 10, 13);

insert into type_of_crime (t_id, t_name) values
(1, 'Кражба'),
(2, 'Физички напад'),
(3, 'Семејно насилство'),
(4, 'Трговија со луѓе'),
(5, 'Шверц со дрога'),
(6, 'Киднапирање/исчезнување');

insert into solved_case (sc_description , final_document, c_id, date_of_closing) values
('Овинителството го затвора случајот со добиен осомничен.', 'data:image/png;base64,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', 2, '2014-01-02'),
('Овинителството го затвора случајот поради истекување на рокот', 'https://republika.mk/wp-content/uploads/2022/07/krivicna-muaremi.jpg', 3, '2017-03-05'),
('Полицијата не го испраќа случајот до обвинителство поради недоволно докази', 'https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQBgaJrCTwRC4oEcRE3ixoABZMopFCDQXsYVYJApkFv0-axp8Mg8Up0UVGm9wuR5vdYTD0&usqp=CAU', 4, '2017-12-11');

-- Физички објект, документ, демонстративен, дигитален, карактерен, научен, фотографија
insert into evidence(e_id, e_name, e_type, is_found, e_picture) values
(1, 'Нож', 'Физички објект', true , 'https://img.freepik.com/free-photo/closeup-shot-sharp-army-knife_181624-14878.jpg?size=626&ext=jpg&ga=GA1.1.938941469.1701200455&semt=ais'),
(2, 'Компјутер', 'Физички објект', false , 'https://m.media-amazon.com/images/I/718sn7oOcfL.jpg'),
(3, 'Видео снимки', 'Дигитален', true, 'https://panacea.mk/wp-content/uploads/2018/07/modrici-2.jpg'),
(4, 'Боксирач', 'Фотографија', true , 'https://faktor.mk/media/main/2016/10/20161013160451.jpg'),
(5, 'Згради', 'Фотографија', false , 'https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTtyAeU33swAJ3VYmMIwSZHxu6Z3lLA9KPdj0SRsS5A1Q&s'),
(6, 'Зграда', 'Фотографија', true, 'https://i0.wp.com/www.pravdiko.mk/wp-content/uploads/2018/04/Osnoven-sud-Skopje-1-nova-zgrada-2apr18-Meta.jpg?ssl=1');

-- evidence_id,statement_id
insert into mentions_evidence(e_id,s_id) values
(1,1),
(2,4),
(3,6),
(4,3),
(5,7),
(6,6);

-- accused_id, case_id
insert into accused_for (accused_pe_id, c_id) values
(1, 3),
(5, 1),
(11, 4),
(22, 2);


insert into case_belongs_to_type_of_crime (c_id, t_id) values
(1, 3),
(2, 1),
(3, 2),
(4, 3),
(5, 6),
(6, 6);
