package mk.ukim.finki.db.distributorapp.vehicle;

import mk.ukim.finki.db.distributorapp.vehicle.dto.VehicleBasicDto;
import mk.ukim.finki.db.distributorapp.vehicle.dto.VehicleDto;

import java.time.LocalDate;
import java.util.List;

public interface VehicleService {

    List<VehicleBasicDto> getVehiclesByWarehouse(Integer warehouseId);

    Integer create(VehicleDto vehicleDto);

    Integer edit(VehicleDto vehicleDto);

    void deleteById(Integer id);

    List<VehicleDto> getVehiclesByManager(Long managerId);

    List<VehicleBasicDto> getBasicVehiclesByManagerId(Long managerId);

    List<VehicleBasicDto> getAvailableVehiclesForDateByManager(Long id, LocalDate date);
}
