package mk.ukim.finki.db.distributorapp.repository;

import lombok.NonNull;
import mk.ukim.finki.db.distributorapp.model.entities.Manufacturer;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;

public interface ManufacturerRepository extends JpaRepository<Manufacturer, Long> {
    @Query(
            nativeQuery = true,
            value = "select * from manufacturer"
    )
    List<Manufacturer> listAll();

    @Query(
            nativeQuery = true,
            value = "select * from manufacturer where man_name like ?1"
    )
    List<Manufacturer> findAllByName(@NonNull String name);

    @Query(
            nativeQuery = true,
            value = "select * from manufacturer where man_id=?1"
    )
    Optional<Manufacturer> findById(@NonNull Long id);

    @Modifying
    @Transactional
    @Query(
            nativeQuery = true,
            value = "insert into manufacturer(man_name, man_address, man_mobile, man_email) " +
                    "values (?1,?2,?3,?4)"
    )
    Integer create(
            @NonNull String name,
            @NonNull String address,
            @NonNull String mobile,
            @NonNull String email);

    @Modifying
    @Transactional
    @Query(
            nativeQuery = true,
            value = "update manufacturer " +
                    "set man_name=?2,man_address=?3,man_mobile=?4,man_email=?5 " +
                    "where man_id=?1"
    )
    Integer edit(
            @NonNull Long id,
            @NonNull String name,
            @NonNull String address,
            @NonNull String mobile,
            @NonNull String email);

    @Modifying
    @Transactional
    @Query(
            nativeQuery = true,
            value = "delete from manufacturer where man_id=?1"
    )
    void delete(@NonNull Long id);
}
