package com.example.domify.service;

import com.example.domify.model.LandlordProfile;
import com.example.domify.model.Lease;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

public interface LeaseService {
    Lease save(Long listingId,
               Long tenantId,
               Long landlordUserId,
               LocalDate startDate,
               LocalDate endDate,
               BigDecimal rentAmount,
               BigDecimal depositAmount);
    List<Lease> findByLandlord(Long landlordId);
    List<Lease> findByTenant(Long tenantId);
    Lease findById(Long leaseId);
    void rateUser(Long leaseId, Long raterId, Integer rating, boolean isRatingTenant);
}
