package com.example.domify.jobs;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.transaction.Transactional;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class PaymentScheduledJobs {

    @PersistenceContext
    private EntityManager entityManager;

    @Scheduled(cron = "0 0 15 3-5 * *")
    @Transactional
    public void callReminderProcedure() {
        entityManager
                .createNativeQuery("CALL domify.send_monthly_payment_reminders2()")
                .executeUpdate();
    }

    @Scheduled(cron = "0 0 18 * * *")
    @Transactional
    public void callUnresolvedServiceReminderProcedure() {
        entityManager
                .createNativeQuery("CALL domify.send_unresolved_service_request_reminders()")
                .executeUpdate();
    }
    @Scheduled(cron = "0 0 12 * * *")
    @Transactional
    public void callOverdueMaintenanceFlagProcedure() {
        entityManager
                .createNativeQuery("CALL domify.flag_landlords_with_overdue_maintenance()")
                .executeUpdate();
    }

    @Scheduled(cron = "0 0  * * *")
    @Transactional
    public void callUpdateListingStatusesProcedure() {
        entityManager
                .createNativeQuery("CALL domify.update_listing_statuses()")
                .executeUpdate();
    }
}
