drop table if exists Vraboten_vo_oddel;
drop table if exists Otsustva;
drop table if exists Vraboteni;
drop table if exists Oddeli;
drop table if exists Firmi;
drop table if exists Vidovi;

create table Vidovi(
	vid_id integer primary key not null,
	vid_otsustvo varchar(100) not null
);

create table Firmi(
	f_id integer primary key not null,
	f_ime varchar(100) not null,
	f_grad varchar(100) not null,
	f_email varchar(100) not null,	
	f_telefon varchar(100) not null,
	f_edb varchar(100) not null,
	f_kontakt varchar(100),
	f_username varchar(100) not null,
	f_password varchar(100) not null,
	f_valid date not null
);

create table Oddeli(
	oddel_id integer primary key not null,
	oddel_naziv varchar(100) not null,
	f_id integer not null references Firmi(f_id)
);

create table Vraboteni(
	v_id integer primary key not null,
	v_ime varchar(100) not null,
	v_prezime varchar(100) not null,
	v_mesto varchar(100),	
	v_telefon varchar(100),
	v_embg varchar(100) not null,
	v_odmor integer not null,
	v_aktiven smallint not null,
	f_id integer not null references Firmi(f_id)
);

create table Otsustva(
	o_id integer primary key not null,
	o_datum date not null,
	o_casovi integer not null,
	o_opis varchar(100),
	v_id integer not null references Vraboteni(v_id),
	vid_id integer not null references Vidovi(vid_id)
);

create table Vraboten_vo_oddel(
	vraboten_od date not null,
	vraboten_do date,
	v_id integer not null references Vraboteni(v_id),
	oddel_id integer not null references Oddeli(oddel_id),
	constraint pk_id primary key(vraboten_od, v_id, oddel_id)
);