﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using Microsoft.AspNetCore.Mvc;

namespace Farmatiko.Controllers
{
    public class AdminController : Controller
    {
        private readonly IAdminService _adminService;
        private readonly IService _service;
        private readonly IPHService _phservice;
        public AdminController(IAdminService adminService, IService service, IPHService phservice)
        {
            _adminService = adminService;
            _service = service;
            _phservice = phservice;
        }

        //GET
        [HttpGet]
        public async Task<IQueryable<PharmacyHead>> GetPharmacyHeads()
        {
            return await _adminService.GetPharmacyHeads();
        }

        [HttpGet]
        public async Task<IQueryable<RequestPharmacyHead>> GetClaimingRequests()
        {
            return await _adminService.GetCalimingRequests();
        }


        //POST
        [HttpPost]
        public async Task<IActionResult> AddPharmacyHead(PharmacyHead pharmacyHead)
        {
            await _service.AddPharmacyHead(pharmacyHead);
            return Ok();
        }

        [HttpPost]
        public async Task<IActionResult> RemovePharmacyHead(PharmacyHead pharmacyHead)
        {
            await _service.RemovePharmacyHead(pharmacyHead);
            return Ok();
        }
        [HttpPost]
        public async Task<IActionResult> RejectRequset(RequestPharmacyHead req)
        {
            await _adminService.RejectRequest(req);
            return Ok();
        }
        [HttpPost]
        public async Task<IActionResult> ApproveRequest(PharmacyHead pharmacyHead)
        {
            await _phservice.UpdatePharmacyHead(pharmacyHead);
            return Ok();
        }

    }
}
