﻿using System.Linq;
using System.Threading.Tasks;
using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using Microsoft.AspNetCore.Mvc;

namespace Farmatiko.Controllers
{
    [ApiController]
    [Route("api/[action]")]
    public class PharmacyHeadController : Controller
    {
        private readonly IPHService _PHService;
        public PharmacyHeadController(IPHService PHService)
        {
            _PHService = PHService;
        }
        
        //GET
        //Mi trebaat rutite
        [HttpGet]
        public async Task<IQueryable<PharmacyHead>> GetPharmacyHeadInfo(string Token)
        {
            return await _PHService.GetPharmacyHeadInfo(Token);
        }
        //POST
        [HttpPost]
        public async Task<int> Login(PharmacyHead pharmacyHead)
        {
            return await _PHService.Login(pharmacyHead);
        }
        [HttpPost]
        public async Task UpdatePharmacyHead(PharmacyHead pharmacyHead)
        {
            await _PHService.UpdatePharmacyHead(pharmacyHead);
        }
        [HttpPost]
        public async Task<IActionResult> ClaimPharmacy(RequestPharmacyHead pharmacy)
        {
            await _PHService.ClaimPharmacy(pharmacy);
            return Ok();
        }
        
    }
}
