﻿using FarmatikoData.Models;
using System.Linq;
using System.Threading.Tasks;

namespace FarmatikoServices.FarmatikoServiceInterfaces
{
    public interface IService
    {
        //GET
        Task<IQueryable<HealthcareWorker>> GetAllWorkers();
        Task<IQueryable<HealthcareWorker>> SearchWorkers(string query);
        Task<HealthcareWorker> GetWorker(int id);
        Task<IQueryable<HealthFacility>> GetFacilities();
        Task<IQueryable<HealthFacility>> SearchFacilities(string query);
        Task<HealthFacility> GetFacility(int id);
        Task<HealthFacility> GetFacilityJSON(string healthFacility);
        Task<Medicine> GetMedicine(int id);
        Task<IQueryable<Medicine>> SearchMedicines(string query);
        Task<IQueryable<Medicine>> GetMedicines();
        Task<Pandemic> GetPandemic();
        Task<IQueryable<Pharmacy>> GetPharmacies();
        Task<IQueryable<Pharmacy>> SearchPharmacies(string query);
        Task<Pharmacy> GetPharmacy(int id);
        //POST
        Task AddWorker(HealthcareWorker worker);
        Task AddFacility(HealthFacility healthFacilities);
        Task AddPharmacy(Pharmacy pharmacy);
        Task AddPharmacyHead(PharmacyHead pharmacyHead);
        Task AddMedicines(Medicine medicine);
        Task AddPandemic(Pandemic pandemic);
        Task UpdateFacility(HealthFacility healthFacilities);
        Task RemoveMedicine(Medicine medicine);
        Task RemovePharmacyHead(PharmacyHead pharmacyHead);
        Task UpdatePandemic(Pandemic pandemic);
        Task RemovePharmacy(Pharmacy pharmacy);
        Task UpdateWorker(HealthcareWorker worker);
        Task UpdatePharmacy(Pharmacy pharmacy);
    }
}
