﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace FarmatikoServices.Services
{
    public class PHService : IPHService
    {
        private readonly IPHRepo _iPHRepo;
        public PHService(IPHRepo iPHRepo)
        {
            _iPHRepo = iPHRepo;
        }

        public async Task ClaimPharmacy(RequestPharmacyHead pharmacy)
        {
            await _iPHRepo.ClaimPharmacy(pharmacy);
        }

        public Task<IQueryable<PharmacyHead>> GetPharmacyHeadInfo(string Token)
        {
            throw new NotImplementedException();
        }

        public async Task<int> Login(PharmacyHead pharmacyHead)
        {
            var PHead = await Task.Run(() => _iPHRepo.GetPharmacyHead(pharmacyHead));
            if (PHead.Password.Equals(pharmacyHead.Password))
                return PHead.Id;
            return -1;
        }


        public async Task UpdatePharmacyHead(PharmacyHead pharmacyHead)
        {
            if (pharmacyHead != null)
                await _iPHRepo.UpdatePharmacyHead(pharmacyHead);
            else throw new Exception("PharmacyHead has a null value.");
        }
    }
}
