﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace FarmatikoData.FarmatikoRepo
{
    public class AdminRepo : IAdminRepo
    {
        private readonly FarmatikoDataContext _context;
        public AdminRepo(FarmatikoDataContext context)
        {
            _context = context;
        }

        public async Task<IQueryable<RequestPharmacyHead>> GetClaimingRequests()
        {
            var reqs = await Task.Run(() => _context.PHRequests.OrderBy(x => x.Head.Name));
            return reqs;
        }

        //GET
        public async Task<IQueryable<PharmacyHead>> GetPharmacyHeads()
        {
            var PHeads = await Task.Run(() => _context.PharmacyHeads.OrderBy(x => x.Name));
            return PHeads;
        }
        //POST
        public async Task RemoveClaimRequest(RequestPharmacyHead req)
        {
            await Task.Run(() => _context.PHRequests.Remove(req));
            await _context.SaveChangesAsync();
        }
    }
}
