﻿using FarmatikoData.FarmatikoRepoInterfaces;
using System;
using System.Linq;
using System.Collections.Generic;
using System.Text;
using FarmatikoData.Models;
using Microsoft.EntityFrameworkCore;

namespace FarmatikoData.FarmatikoRepo
{
    public class HealthFacilityRepository : IHealthFacilityRepository
    {
        private FarmatikoDataContext _context;

        public HealthFacilityRepository(FarmatikoDataContext context)
        {
            _context = context;
        }

        public void Add(HealthFacilities healthFacility)
        {
            _context.Add(healthFacility);
            _context.SaveChangesAsync();
        }

        public IEnumerable<HealthFacilities> GetAll()
        {
            return _context.HealthFacilities;
        }

        public HealthFacilities GetByFullName(string FullName)
        {
            return (HealthFacilities)_context.HealthFacilities
                .Where(Facility => Facility.Name == FullName)
                .FirstOrDefault(Facility => Facility.Name == FullName);
        }

        public HealthFacilities GetByType(string FacilityType)
        {
            return (HealthFacilities)_context.HealthFacilities
                .Where(FacilityType => FacilityType.Type.Equals(FacilityType))
                .FirstOrDefault(FacilityType => FacilityType.Name.Equals(FacilityType));
        }

        public void Remove(string healthFacility)
        {
            HealthFacilities Facility = (HealthFacilities)_context.HealthFacilities.Where(healthFacility => healthFacility.Name.Equals(healthFacility));
            _context.Remove(Facility);
            _context.SaveChangesAsync();
        }

    }
}
