﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using System;
using System.Linq;
using System.Collections.Generic;
using System.Text;
using Microsoft.EntityFrameworkCore;

namespace FarmatikoData.FarmatikoRepo
{
    public class HealthcareWorkersRepository : IHealthcareWorkersRepository
    {

        private FarmatikoDataContext _context;

        public HealthcareWorkersRepository(FarmatikoDataContext context)
        {
            _context = context;
        }

        public void Add(HealthcareWorkers HealthcareWorker)
        {
            _context.Add(HealthcareWorker);
            _context.SaveChangesAsync();
        }

        public IEnumerable<HealthcareWorkers> GetAll()
        {
            return _context.HealthcareWorkers;
        }

        public ICollection<HealthcareWorkers> GetByBranch(string Branch)
        {
            return (ICollection<HealthcareWorkers>)_context.HealthcareWorkers.Where(healthcareWorker => healthcareWorker.Branch == Branch);
        }

        public ICollection<HealthcareWorkers> GetByFacility(HealthFacilities HealthFacility)
        {
            return (ICollection<HealthcareWorkers>)_context.HealthcareWorkers.Where(Facility => Facility.Facility.Equals(HealthFacility));
        }

        public HealthcareWorkers GetByName(string Name)
        {
            return (HealthcareWorkers)_context.HealthcareWorkers.Where(healthcareWorker => healthcareWorker.Name == Name);
        }
    }
}
